;Stranded - Terrain File

;Terrain erstellen
Function terrain_create(hmap$="gfx/terrain_hmap.bmp")
	If terrain<>0 Then FreeEntity terrain
	terrain=LoadTerrain(hmap$)
	If terrain=0 Then RuntimeError("Terrain konnte nicht geladen werden")
	ScaleEntity terrain,5,100,5
	EntityTexture terrain, gfx_terrain,0,0
	EntityTexture terrain, gfx_terdetail,0,1
	EntityTexture terrain, gfx_tshadow,0,2
	EntityType terrain,ct_flora
	TerrainDetail terrain, 500,1
	EntityPickMode terrain, 2,1
	TerrainShading terrain, 1
	ed_minimap()
End Function

;Pflanzen erstellen
Function terrain_flora(count)
	;Pflanzen
	Local typ
	For i = 0 To count
		typ=10
		If Rand(3)=1 Then typ=1				;Palme
		If Rand(3)=1 Then typ=2				;Palme
		If Rand(30)=1 Then typ=3			;Palme
		If Rand(2)=1 Then typ=4				;Palme
		If Rand(80)=1 Then typ=5			;Palme
		If Rand(100)=1 Then typ=6			;Trockender Baum
		If Rand(15)=1 Then typ=7			;Palme
		If Rand(45)=1 Then typ=31			;Beeren Busch
		If Rand(10)=1 Then typ=40			;Busch
		If Rand(7)=1 Then typ=41			;Busch
		If Rand(30)=1 Then typ=42			;Busch
		If Rand(30)=1 Then typ=43			;Busch
		If Rand(40)=1 Then typ=20			;Korn
		If Rand(40)=1 Then typ=50			;Stein
		If Rand(80)=1 Then typ=51			;Stein-Spitz
		If Rand(55)=1 Then typ=52			;Quellen-Stein
		If Rand(5)=1 Then typ=10			;Gras
		terrain_flora_add(Rand(100)*15, 10, Rand(100)*15, typ)
	Next
End Function

;Pflanze erstellen
Function terrain_flora_add(x, y#, z, typ, scale#=0, yaw=-1000, value=0, health=0, timer=0)
	Local ha, h, w, ct, cancel=0
	If Int(x/15)<0 Then Return 0
	If Int(x/15)>msz Then Return 0
	If Int(z/15)<0 Then Return 0
	If Int(z/15)>msz Then Return 0
	y#=TerrainY(terrain, x, y, z)
	If y<7.5 Then
		cancel=1
	EndIf
	Select typ
		Case 71 cancel=0
	End Select
	If cancel=1 Then Return 0
	For flora.flora = Each flora
		If EntityX(flora\h)=x Then
			If EntityZ(flora\h)=z Then
				Return 0
			EndIf
		EndIf
	Next
	flora.flora = New flora
	Select typ
		Case 1											;1 Palme
			y=y+16
			ha=CopyMesh(m_palm1)
			If yaw=-1000 Then Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=80
			mapfree(Int(x/15),Int(z/15))=1
		Case 2											;2 Palme
			y=y+28
			ha=CopyMesh(m_palm2)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=110
			mapfree(Int(x/15),Int(z/15))=1
		Case 3											;3 Palme
			y=y+16
			ha=CopyMesh(m_palm3)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=90
			mapfree(Int(x/15),Int(z/15))=1
		Case 4											;4 Palme
			y=y+16
			ha=CopyMesh(m_palm4)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=70
			mapfree(Int(x/15),Int(z/15))=1
		Case 5											;5 Palme
			y=y+16
			ha=CopyMesh(m_palm5)
			If yaw=-1000 Then Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=100
			mapfree(Int(x/15),Int(z/15))=1
		Case 6											;6 Tockener "Baum"
			y=y+0
			ha=CopyMesh(m_drytree)
			If yaw=-1000 Then Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			ScaleEntity ha,0.6,0.6,0.6
			EntityType ha,ct_flora
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1
		Case 7											;7 Palme
			y=y+16
			ha=CopyMesh(m_palm6)
			If yaw=-1000 Then Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			ScaleEntity ha,0.7,0.7,0.7
			EntityType ha,ct_flora
			flora\health=80
			mapfree(Int(x/15),Int(z/15))=1
		Case 8											;9 Tanne
			y=y+0
			ha=CopyMesh(m_tree1)
			If yaw=-1000 Then Rand(-180, 180)
			RotateEntity ha,Rnd(-10,10),yaw,Rnd(-10,10)
			EntityFX ha, 16
			;ScaleEntity ha,1.0,1.0,1.0
			EntityType ha,ct_flora
			flora\health=100
			mapfree(Int(x/15),Int(z/15))=1
		Case 10											;10 Gras	
			ha=CopyMesh(m_gras)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			EntityFX ha, 16
			scale#=Rnd(0.5,0.8)
			EntityColor ha, 0,128,0
			ScaleEntity ha,scale#*1.5,scale#,scale#*1.5
			y=y+h-0.0
		Case 20											;20 Korn
			ha=CopyMesh(m_corn)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			If value=0 Then value=3
			RotateEntity ha,0,yaw,0
			scale#=0.25
			ScaleEntity ha,scale#,scale#,scale#
			EntityColor ha,255,255,100
			y=y+h+0
			EntityFX ha, 16
			mapfree(Int(x/15),Int(z/15))=1
		Case 21											;21 Hanf
			ha=CopyMesh(m_hemp)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			If value=0 Then value=3
			RotateEntity ha,0,yaw,0
			scale#=0.2
			ScaleEntity ha,scale#,scale#,scale#
			EntityColor ha,50,255,50
			y=y+h+0
			EntityFX ha, 16
			mapfree(Int(x/15),Int(z/15))=1			
		Case 30											;30 Busch Beeren (leer)
			ha=CopyMesh(m_bush1)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.6
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1
		Case 31											;31 Busch Beeren (voll)
			ha=CopyMesh(m_bush1b)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.6
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1
		Case 32											;32 Busch Gummibeerem (leer)
			ha=CopyMesh(m_bush1)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.6
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1
		Case 33											;33 Busch Gummibeeren (voll)
			ha=CopyMesh(m_bush1c)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.6
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1		
		Case 40											;40 Busch
			ha=CopyMesh(m_bush2)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.5
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=40
			mapfree(Int(x/15),Int(z/15))=1
		Case 41											;41 Busch
			ha=CopyMesh(m_bush3)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.5
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=40
			mapfree(Int(x/15),Int(z/15))=1
		Case 42											;42 Busch
			ha=CopyMesh(m_bush4)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.5
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=40
			mapfree(Int(x/15),Int(z/15))=1
		Case 43											;43 Busch
			ha=CopyMesh(m_bush5)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			scale#=0.5
			ScaleEntity ha,scale#,scale#,scale#
			y=y+h+0
			EntityFX ha, 16
			flora\health=40
			mapfree(Int(x/15),Int(z/15))=1
		Case 50											;50 Stein
			y=y+0
			ha=CopyMesh(m_stone1)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=Rnd(0.1,0.6)
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
			EntityType ha,ct_flora
			flora\health=40
			mapfree(Int(x/15),Int(z/15))=1
		Case 51											;51 Stein (spitz)
			y=y+0
			ha=CopyMesh(m_stone2)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=Rnd(0.2,0.8)
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#*1.5,scale#
			EntityType ha,ct_slide
			flora\health=50
			mapfree(Int(x/15),Int(z/15))=1
		Case 52											;52 Quellen Stein
			y=y+0
			ha=CopyMesh(m_stone1)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.5
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
			EntityType ha,ct_slide
			flora\health=100
			mapfree(Int(x/15),Int(z/15))=1
		Case 60											;60 Blumen
			y=y+0
			ha=CopyMesh(m_flowers)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.2
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
		Case 61											;61 Blumen 2
			y=y+0
			ha=CopyMesh(m_flowers2)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.2
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
		Case 62											;62 Blumen 3
			y=y+0
			ha=CopyMesh(m_flowers3)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.2
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
		Case 63											;63 Blumen 4
			y=y+0
			ha=CopyMesh(m_flowers4)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.2
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
		Case 70											;70 Lwenstein
			y=y+0
			ha=CopyMesh(m_lionstone)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			EntityFX ha,16
			scale#=0.3
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
			EntityType ha,ct_slide
			mapfree(Int(x/15),Int(z/15))=1
		Case 71											;71 Schildkrten Eier
			y=y+0
			ha=CopyMesh(m_eggs)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.4
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
			mapfree(Int(x/15),Int(z/15))=1
		Case 72											;72 Kiwi Eier
			y=y+0
			ha=CopyMesh(m_eggs)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.2
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
			mapfree(Int(x/15),Int(z/15))=1
		Default											;Default Gras
			typ=10
			ha=CopyMesh(m_gras)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			RotateEntity ha,0,yaw,0
			EntityFX ha, 16
			scale#=Rnd(0.3,0.4)
			ScaleEntity ha,scale#,scale#,scale#
			EntityColor ha, 0, 128, 0
			y=y+h-0.0
	End Select
	;EntityAutoFade ha, opt_autofade_s, opt_autofade_e
	EntityPickMode ha, 2,1
	flora\typ=typ
	flora\h=ha
	flora\visible=1
	flora\scale=scale
	flora\value=value
	If health > 0 Then flora\health=health
	flora\timer=timer
	PositionEntity ha, x, y, z
	ShowEntity ha
	e_flora.flora = First flora
	Return 1
End Function

;Tiere erstellen
Function terrain_fauna(count)
	Local typ
	;Tiere
	For i = 0 To count
		typ=2
		If Rand(5)=1 Then typ=1				;Schildkrte
		If Rand(10)=1 Then typ=3			;Giftpflanze
		If Rand(5)=1 Then typ=2				;Krebs
		If Rand(5)=1 Then typ=4				;Schmetterling
		If Rand(40)=1 Then typ=5			;Lwe
		If Rand(10)=1 Then typ=8			;Kiwi
		If Rand(25)=1 Then typ=12			;Vogel
		terrain_fauna_add(Rand(msz+1)*15, 10, Rand(msz+1)*15, typ)
	Next
End Function

;Tier erstellen
Function terrain_fauna_add(x, y#, z, typ, yaw#=0, timer=0, mode=0, turnmode=0, age=0, health=0, targetyaw=0)
	Local ha, h, w, ct
	y#=TerrainY(terrain, x, y, z)
	For fauna.fauna = Each fauna
		If EntityX(fauna\h)=x Then
			If EntityZ(fauna\h)=z Then
				Return 0
			EndIf
		EndIf
	Next
	If typ=3 Then
		For flora.flora = Each flora
			If EntityX(flora\h)=x Then
				If EntityZ(flora\h)=z Then
					Return 0
				EndIf
			EndIf
		Next		
	EndIf
	If y#<5.5 Then
		If typ=3 Then Return 0
		If typ=5 Then Return 0
		If typ=8 Then Return 0
		If typ=9 Then Return 0
	ElseIf y#<>0.0 Then
		If typ=7 Then Return 0
	EndIf
	fauna.fauna = New fauna
	Select Typ
		Case 1													;1 Schildkrte
			ha=CopyEntity(m_turtle)
			ScaleEntity ha,0.2,0.2,0.2
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.7,z
			EntityType ha,ct_fauna
			fauna\health=49
		Case 2													;2 Krebs
			ha=CopyEntity(m_cancer)
			ScaleEntity ha,0.07,0.07,0.07
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.3,z
			EntityType ha,ct_fauna
			fauna\health=19
		Case 3													;3 Giftpflanze
			ha=CopyEntity(m_flower)
			ScaleEntity ha,0.2,0.2,0.2
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.8,z
		Case 4													;4 Schmetterling
			ha=CopyEntity(m_butterfly)
			ScaleEntity ha,0.1,0.1,0.1
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+8,z
			Animate ha,1,1,0,1
		Case 5													;5 Lwe
			ha=CopyEntity(m_lion)
			ScaleEntity ha,0.35,0.35,0.35
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.0,z
			EntityType ha,ct_fauna
			fauna\health=59
		Case 6													;6 Oldman
			ha=CopyEntity(m_oldman)
			ScaleEntity ha,0.5,0.5,0.5
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.0,z
			EntityType ha,ct_fauna
			fauna\health=119
		Case 7 													;7 Hai
			ha=CopyEntity(m_shark)
			ScaleEntity ha,0.15,0.15,0.15
			PositionEntity ha, x,0,z
			EntityType ha,ct_fauna
			fauna\health=59
		Case 8													;8 Kiwi
			ha=CopyEntity(m_kiwi)
			ScaleEntity ha,0.12,0.12,0.12
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.0,z
			EntityType ha,ct_fauna
			fauna\health=9		
		Case 9													;9 Raptor
			ha=CopyEntity(m_raptor)
			ScaleEntity ha,0.25,0.25,0.25
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+2.2,z
			EntityType ha,ct_fauna
			fauna\health=79
		Case 10													;10 Soldat
			ha=CopyEntity(m_soldier)
			ScaleEntity ha,0.3,0.28,0.3
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.0,z
			EntityType ha,ct_fauna
			fauna\health=69
		Case 11													;11 Eingeborener
			ha=CopyEntity(m_native)
			ScaleEntity ha,0.3,0.28,0.3
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+0.0,z
			EntityType ha,ct_fauna
			fauna\health=159
		Case 12													;12 Vogel
			ha=CopyEntity(m_bird)
			ScaleEntity ha,0.3,0.3,0.3
			EntityFX ha, 16
			PositionEntity ha, x,TerrainY(terrain,x,y,z)+80,z
			EntityType ha,ct_fauna
			fauna\health=9
	End Select
	RotateEntity ha, 0,yaw#,0
	;EntityAutoFade ha, opt_autofade_s, opt_autofade_e
	EntityPickMode ha, 2,1
	fauna\typ=typ
	fauna\h=ha
	fauna\timer=timer
	fauna\mode=mode
	fauna\turnmode=turnmode
	fauna\age=age
	fauna\targetyaw=targetyaw
	If health<>0 Then fauna\health=health
	fauna\visible=1
	e_fauna.fauna = First fauna
	Return 1
End Function

;Statics erstellen
Function terrain_static(count)
	Local typ
	For i = 0 To count
		typ=1
		If Rand(5)=1 Then typ=1					;Muschel
		If Rand(10)=2 Then typ=2				;Seestern
		terrain_static_add(Rand(100)*15, 10, Rand(100)*15, typ)
	Next
End Function

;Static erstellen
Function terrain_static_add(x,y#,z, typ, yaw=-1000)
	Local ha, w, ct
	y#=TerrainY(terrain, x, y, z)
	If y>6 Then
		Return 0
	EndIf
	static.static = New static
	Select typ
		Case 1											;1 Muschel
			y=y+0.5
			ha=CopyMesh(m_shell)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.1
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#
		Case 2											;2 Seestern
			y=y+0.3
			ha=CopyMesh(m_seastar)
			If yaw=-1000 Then yaw=Rand(-180, 180)
			scale#=0.1
			RotateEntity ha,0,yaw,0
			ScaleEntity ha,scale#,scale#,scale#		
	End Select
	EntityAutoFade ha, opt_autofade_s, opt_autofade_e
	static\typ=typ
	static\h=ha
	static\visible=1
	PositionEntity ha, x, y, z
	ShowEntity ha
	e_static.static = First static
	Return 1
End Function

;Building erstellen
Function terrain_building_add(x#,y#,z#, typ, msg=0, mode=0, timer=0, yaw#=0, value$=0)
	Local ha
	For building.building = Each building
		If building\h1<>0 Then
			If EntityX(building\h1)=x Then
				If EntityZ(building\h1)=z Then
					Return 0
				EndIf
			EndIf
		EndIf
	Next
	y#=TerrainY(terrain, x, y, z)
	building.building = New building
	Select typ
		;Htte
		Case 1
			If msg Then msg("Htte errichtet",1,1)
			building\h1=CopyEntity(m_house)	
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_slide
			PositionEntity building\h1, x#,y#,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Baumhaus
		Case 2
			If msg Then msg("Baumhaus errichtet",1,1)
			building\h1=CopyEntity(m_treehouse)	
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#+35,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Feuerstelle
		Case 3
			If msg Then msg("Feuerstelle errichtet",1,1)
			building\h1=CopyEntity(m_fire)	
			ScaleEntity building\h1, 0.25,0.25,0.25
			EntityType building\h1, ct_slide
			PositionEntity building\h1, x#,y#,z#
			building\h2=CopyEntity(s_fire)
			ScaleSprite building\h2, 3,8
			SpriteViewMode building\h2, 4
			EntityFX building\h2, 9
			PositionEntity building\h2, x#,y#+6.5,z#
			building\h3=CreateLight(2)
			LightRange building\h3, 15
			PositionEntity building\h3, x#,y#+5,z#
			LightColor building\h3, 255,150,0
			EntityPickMode building\h1, 2,1
		;Flo
		Case 4
			If msg Then msg("Flo errichtet",1,1)
			building\h1=CopyEntity(m_boat)	
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,0.6,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Fackel
		Case 5
			If msg Then msg("Fackel errichtet",1,1)
			building\h1=CopyEntity(m_torch)	
			ScaleEntity building\h1, 0.25,0.25,0.25
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#,z#
			building\h2=CopyEntity(s_fire)
			ScaleSprite building\h2, 1.5,5
			SpriteViewMode building\h2, 4
			EntityFX building\h2, 9
			PositionEntity building\h2, x#,y#+12,z#
			building\h3=CreateLight(2)
			LightRange building\h3, 15
			PositionEntity building\h3, x#,y#+10,z#
			LightColor building\h3, 255,150,0
			EntityPickMode building\h1, 2,1
		;Lager
		Case 6
			If msg Then msg("Lager errichtet",1,1)
			building\h1=CopyEntity(m_storage)
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Reuse
		Case 7
			If msg Then msg("Reuse errichtet",1,1)
			building\h1=CopyEntity(m_reuse)
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,0.6,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#	
		;Checkpoint
		Case 10
			building\h1=CopyEntity(m_checkp)
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Ziel
		Case 11
			building\h1=CopyEntity(m_finish)
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Kiwi Point
		Case 12
			building\h1=CopyEntity(m_kiwip)
			EntityFX building\h1, 16
			ScaleEntity building\h1, 0.4,0.4,0.4
			EntityType building\h1, ct_flora
			PositionEntity building\h1, x#,y#,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Schiffswrack
		Case 20
			building\h1=CopyEntity(m_wreck)		
			PositionEntity building\h1, x#,0,z#
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Wand
		Case 21
			building\h1=CopyEntity(m_wall)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.5,0.5,0.5
			EntityType building\h1, ct_slide
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Wand Ecke
		Case 22
			building\h1=CopyEntity(m_wallc)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.5,0.5,0.5
			EntityType building\h1, ct_slide
			EntityFX building\h1, 16
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Kiste - Munition
		Case 25
			building\h1=CopyEntity(m_cammo)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.35,0.35,0.35
			EntityType building\h1, ct_flora
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Kiste - Pistole
		Case 26
			building\h1=CopyEntity(m_cpistol)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.35,0.35,0.35
			EntityType building\h1, ct_flora
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#	
		;Kiste - AK
		Case 27
			building\h1=CopyEntity(m_cak)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.35,0.35,0.35
			EntityType building\h1, ct_flora
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Spikewall
		Case 30
			building\h1=CopyEntity(m_spikes)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.3,0.3,0.3
			EntityType building\h1, ct_flora
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
		;Pfahl
		Case 31
			building\h1=CopyEntity(m_smallstake)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.2,0.2,0.2
			EntityType building\h1, ct_flora
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#			
		;groer Pfahl
		Case 32
			building\h1=CopyEntity(m_stake)		
			PositionEntity building\h1, x#,y#,z#
			ScaleEntity building\h1, 0.6,0.6,0.6
			EntityType building\h1, ct_flora
			EntityPickMode building\h1, 2,1
			building\h2=CreatePivot():PositionEntity building\h2, x#,y#,z#
			building\h3=CreatePivot():PositionEntity building\h3, x#,y#,z#
	End Select
	RotateEntity building\h1, 0,yaw#,0
	building\typ=typ
	building\mode=mode
	building\timer=timer
	building\value$=value$
	EntityAutoFade building\h1, opt_autofade_s, opt_autofade_e
	x=Int(x/15)
	z=Int(z/15)
	If x>=0 And z>=0 And x<=msz And z<=msz Then
		mapfree(x,z)=1
	EndIf
End Function