;Stranded - Load File


;-----Konstanten
Const version$="1.40"		;Version
Const release$="30.05.2006"	;Release Date

Const ct_player=1			;Collision Type Player
Const ct_flora=2			;Collision Type Flora
Const ct_fauna=3			;Collision Type Fauna
Const ct_slide=4			;Collision Type Slide (rutschig, unbekletterbar)

Const pl_mspeed#=0.7		;Spieler Geschwindigkeit
Const pl_take=9000			;Spieler Mitnehmgewicht
Const pl_skillup=50			;Skill UP
Const pl_skillupp=5			;Skill UP Power

Const msz=85				;Map Size

Const gamespeed=200			;1 Game Minute in Realtime MS


;-----Types

;Flora
Type flora
	Field h
	Field typ
	Field timer
	Field value
	Field health
	Field visible
	Field scale#
End Type

;Fauna
Type fauna
	Field h
	Field ph
	Field typ
	Field timer
	Field mode
	Field turnmode
	Field targetyaw
	Field attack
	Field age
	Field health
	Field steps
	Field visible
End Type

;Statics
Type static
	Field h
	Field typ
	Field visible
End Type

;Buildings
Type building
	Field h1
	Field h2
	Field h3
	Field typ
	Field visible
	Field mode
	Field timer
	Field req_ast
	Field req_blatt
	Field req_stein
	Field req_liane
	Field req_baumstamm
	Field req_total
	Field buildstep
	Field value$
End Type

;Buttons (fr Men)
Type button
	Field label$
	Field x,y
End Type

;Effects
Type effect
	Field h
	Field typ
	Field age
	Field alpha#
	Field size#
	Field rot#
	Field fx#
	Field fy#
	Field fz#
End Type
effect.effect = New effect

;Items
Type item
	Field h
	Field typ
	Field timer
	Field age
End Type


;-----Arrays

Dim mapfree(msz,msz)						;Tile begehbar oder nicht?


;-----Variablen

;Mainloop
Global mxs#									;Mouse X Bewegung
Global mys#									;Mouse Y Bewegung
Global mx									;Mouse X
Global my									;Mouse Y
Global md									;Mouse Down (links)
Global md2									;Mouse Down (rechts)
Global mh									;Mouse Hit
Global over									;Button Over
Global ms									;Millisecs
Global fps, fpsm, fpst						;FPS
Global timer1								;Timer
Global timer2								;Timer 2
Global timer3								;Timer 3
Global timer_gui							;Timer GUI
Global timer_gui_run						;Timer GUI Run
Global timer_waves							;Timer Waves
Global gamestop								;Pause (general)
Global pause								;Pause (durch User)
Global script								;Script Aktion
Global script_timer							;Script Timer
Global script_timer2						;Script Timer 2
Global script_icon							;Script Icon
Global multidown							;
Global rendertime							;
Global updatetime							;
Global looptime								;
Global loadsaved$							;
Global loaddir$								;

;Options
file=ReadFile("settings.cfg")
Global opt_debug=0							;Debug
Global opt_autofade_s=0						;Autofade Start
Global opt_autofade_e=0						;Autofade End
Global opt_msens#=ReadLine(file)			;Mouse Sensivity
Global opt_range=ReadLine(file)				;Sightfield Range
Global opt_rangeh=opt_range/1.3				;Show/Hide Range
Global opt_sx=ReadLine(file)				;Screen X
Global opt_sy=ReadLine(file)				;Screen Y
Global opt_sbyte=ReadLine(file)				;Screen Byte
Global opt_vsync=ReadLine(file)				;VSync
Global opt_alias=ReadLine(file)				;Antialias
Global opt_c_msens#							;Cache
Global opt_c_range							;Cache
Global opt_c_sx								;Cache
Global opt_c_sy								;Cache
Global opt_c_sbyte							;Cache
Global opt_c_gamma							;Cache
CloseFile(file)

;Player
Global pl_health							;HP
Global pl_health_max						;
Global pl_health_up							;
Global pl_health_cache						;
Global pl_power								;Kraft
Global pl_power_up							;
Global pl_tired								;Mdigkeit
Global pl_hunger							;Hunger
Global pl_thirst							;Durst
Global pl_hi								;Bekifft
Global pl_hizoom#							;Bekifft camera zoom
Global pl_hizm								;Bekifft camera zoom mode
Global pl_jumpmode							;
Global pl_jumpspeed#						;
Global pl_fallspeed#						;
Global pl_walk								;
Global pl_multimove							;
Global pl_down								;Nchster Abzug
Global pl_tilex								;
Global pl_tiley								;
Global pl_tilebuild							;
Global pl_tilebuildr						;
Global pl_tilebuildb						;
Global pl_tileflora							;
Global pl_tilefauna							;
Global pl_action$							;Action
Global pl_actionakt							;
Global pl_actiontotal						;
Global pl_tool								;Gewhltes Tool
Global pl_toolakt							;
Global pl_tooltotal=1						;
Global pl_toolmsg$							;
Global pl_drive								;
Global pl_driveh							;
Global pl_driveacc#							;
Global pl_quest								;-ungenutzt
Global pl_trade								;Handel mit Opa
Global pl_train								;Ausbildung mit Eingeborenem
Global pl_rubber							;Gummibren
Global pl_menaction							;

;Game - Options
Global gm_custom							;Custom Mission?
Global gm_arcade							;Arcade (kein essen/trinken/mde)
Global gm_time								;Timer
Global gm_time_ms							;
Global gm_rain								;immer Regen?
Global gm_infinitespear						;Unendlich viele Speere?
Global gm_infiniteammo						;Unendlich viel Munition
Global gm_frozentime						;Zeit luft nicht weiter
Global gm_texture$							;Textur
Global gm_track$							;Soundtrack
;Game - Cache
Global gm_checkp							;Erreichte Checkpoints
Global gm_kiwis								;Gerettete Kiwis
Dim gm_killed(30)							;Gettete Tiere
;Game - Missions Ziele
Dim gm_mi_kill(30)							;Ziel: X Typ Tiere tten
Global gm_mi_checkp							;Ziel: X Checkpoints erreichen
Global gm_mi_kiwis							;Ziel: X Kiwis retten
Global gm_mi_finish							;Ziel: Ziel erreichen
Global gm_mi_distance=5000					;Ziel: Distanz mit Boot fahren
;Game - Custom Message
Dim gm_cm$(30)								;Custom Message
Global gm_briefing$							;Briefing Textfile

;Editor
Global ed_selcat							;Gewhlte Kategorie
Dim ed_sel(3)								;Gewhltes Objekt
Dim ed_id(3)								;Gewhltes Objekt -> ID
Dim ed_h(3)									;Handel fr Objekt
Dim ed_name$(3)								;Name fr Objekt
Global ed_map$								;Aktuelle Map

;Cache
Global c_cnt_house
Global c_cnt_treehouse
Global c_cnt_fire
Global c_cnt_boat
Global c_cnt_torch
Global c_cnt_storage
Global c_cnt_reuse
Global c_respawn_x#
Global c_respawn_y#
Global c_respawn_z#
Global c_respawn_timer

;Items
Dim pl_item(15)								;Item ID
Dim pl_items(15)							;Item selected
Dim pl_itemc(15)							;Item Count
Global pl_itemsgew							;Items Gewicht
Global pl_itemss							;Items Selected

;Tools
Global tl_knife=0							;Messer?
Global tl_ak=0								;AK?
Global tl_pistol=0							;Pistole?
Global tl_netz=0							;Netz?
Global tl_speer=0							;Speer?
Global tl_angel=0							;Angel?
Global tl_axt=0								;Axt?
Global tl_hammer=0							;Hammer?
Global tl_stnschl=0							;Steinschleuder?

;Gametime
Global gt
Global gt_min
Global gt_hour
Global gt_day
Global gt_dn
Global gt_light

;Weather
Global w_rd									;Rain-Day?
Global w_chan								;Weather Channel

;Engine
Global e_flora.flora = First flora
Global e_fauna.fauna = First fauna
Global e_static.static = First static

;Menu
Global menu=0
Global menu_newlabel$
Global menu_scroll=0
Global menu_map
Global menu_mapname$

;GUI
Global gui_on
Global gui_menu
Global gui_mx
Global gui_my
Global gui_iteminf1$
Global gui_iteminf2$
Global gui_itemsel
Global gui_itemselid
Global gui_message
Global gui_messageon
Global gui_offset
Global gui_paperoffset
Global gui_blink
Global gui_selinput
Dim gui_msg$(5)
Dim gui_msgt(5)
Dim gui_msgc(5)
Dim gui_checkb(30)
Dim gui_input$(30)

;Grid
Global grid
Global grid_master
Dim grid_x(msz)
Dim grid_z(msz)

;Wire
Global wire

;Object Cache
Global ob_x#
Global ob_y#
Global ob_z#
Global ob_h
Global ob_dx
Global ob_dy
Global ob_typ
Global ob_timer
Global ob_mode

Global ts_s = 512


;-----Initiale Graphics
If Not GfxMode3DExists(opt_sx, opt_sy, opt_sbyte) Then
	opt_sx=640
	opt_sy=480
	opt_sbyte=16
	menu=4
	file=WriteFile("settings.cfg")
	WriteLine file, opt_msens#
	WriteLine file, opt_range
	WriteLine file, opt_sx
	WriteLine file, opt_sy
	WriteLine file, opt_sbyte
	WriteLine file, opt_vsync
	CloseFile(file)
	If Not GfxMode3DExists(640, 480, 16) Then
		opt_sx=800
		opt_sy=600
		opt_sbyte=16
		menu=4
		file=WriteFile("settings.cfg")
		WriteLine file, opt_msens#
		WriteLine file, opt_range
		WriteLine file, opt_sx
		WriteLine file, opt_sy
		WriteLine file, opt_sbyte
		WriteLine file, opt_vsync
		CloseFile(file)
	EndIf
EndIf 
Graphics3D opt_sx, opt_sy, opt_sbyte
AntiAlias 0
SetBuffer BackBuffer()
HidePointer()


;-----Loadscreen
Global font_tiny=LoadFont("Comic Sans MS", 14, 1)
Global font_norm=LoadFont("Comic Sans MS", 16, 1)
Global font_menu=LoadFont("Comic Sans MS", 24, 1)
SetFont font_norm
Global gfx_icon = LoadImage("gfx/icon.bmp")
Global gfx_wait=LoadImage("gfx/wait.bmp"): MidHandle gfx_wait


;-----Gfx
load_screen("Loading Images", 5)

;Images
Global gfx_gui_pointer=LoadImage("gfx/gui_pointer.bmp")
Global gfx_gui_pointerc=LoadImage("gfx/gui_pointercross.bmp"): MidHandle gfx_gui_pointerc
Global gfx_gui_ch=LoadAnimImage("gfx/gui_ch.bmp",51,46,0,2): MidHandle gfx_gui_ch
Global gfx_gui_back=LoadImage("gfx/gui_back.bmp") : MaskImage gfx_gui_back, 255,0,255
Global gfx_gui_back_m1=LoadImage("gfx/gui_back_m1.bmp") : MaskImage gfx_gui_back_m1, 255,0,255
Global gfx_gui_back_m2=LoadImage("gfx/gui_back_m2.bmp") : MaskImage gfx_gui_back_m2, 255,0,255
Global gfx_gui_back_m3=LoadImage("gfx/gui_back_m3.bmp") : MaskImage gfx_gui_back_m3, 255,0,255
Global gfx_gui_popup=LoadAnimImage("gfx/gui_popup.bmp",68,68,0,12) : MaskImage gfx_gui_popup, 255,0,255
Global gfx_gui_items=LoadAnimImage("gfx/gui_items.bmp",25,25,0,31) : MaskImage gfx_gui_items, 255,0,255
Global gfx_gui_paper=LoadImage("gfx/gui_paper.bmp")
Global gfx_icon_story=LoadImage("gfx/icon_story.bmp"): MaskImage gfx_icon_story, 255,0,255
Global gfx_icon_help=LoadImage("gfx/icon_help.bmp"): MaskImage gfx_icon_help, 255,0,255

;Texures
Global gfx_dummy = LoadTexture("gfx/dummy.bmp")
Global gfx_heading = LoadTexture("gfx/heading.bmp",2)
Global gfx_water = CreateTexture(256,256,1+128+256);LoadTexture("gfx/tex_water.bmp",1)
Global gfx_water2 = LoadTexture("gfx/tex_water.bmp",1)
Global gfx_water3 = LoadTexture("gfx/tex_water.bmp",1)
Global gfx_sky = LoadTexture ("gfx/tex_sky.bmp")
Global gfx_sand = LoadTexture ("gfx/tex_sand.bmp")
Global gfx_terrain = LoadTexture ("gfx/tex_terrain.bmp") : ScaleTexture gfx_terrain, 256, 256
Global gfx_tshadow = CreateTexture(ts_s,ts_s,256) : ScaleTexture gfx_tshadow, 256, 256 : TextureBlend gfx_tshadow,2
Global gfx_terdetail = LoadTexture("gfx/CrackedStone.bmp") ScaleTexture gfx_terdetail,3,3 : TextureBlend gfx_terdetail,2
Global gfx_wave = LoadTexture("gfx/wave.bmp",4)
Global gfx_puff = LoadTexture("gfx/puff.bmp",2):Global gfx_puffrot#
Global gfx_ammo = LoadTexture("gfx/ammo.bmp",4)
Global gfx_splatter = LoadTexture("gfx/splatter.bmp",2)
Global gfx_fragment = LoadTexture("gfx/fragment.bmp",4)
Global gfx_rain = LoadTexture("gfx/rain.bmp",4)
Global gfx_splash = LoadTexture("gfx/splash.bmp",4)
Global gfx_stone = LoadTexture("gfx/stone.bmp",4)

;Mask
Global gfx_mask
Global gfx_mask2

;Minimap
Global gfx_minimap = CreateImage(70,70)
MaskImage gfx_minimap, 255,0,255


;Models
Global m_palm1=LoadMesh("models\palm1.b3d"):PositionEntity m_palm1,0,-5000,0:HideEntity m_palm1
Global m_palm2=LoadMesh("models\palm2.b3d"):PositionEntity m_palm2,0,-5000,0:HideEntity m_palm2
Global m_palm3=LoadMesh("models\palm3.b3d"):PositionEntity m_palm3,0,-5000,0:HideEntity m_palm3
TextureFilter "",4:Global m_palm4=LoadMesh("models\palm4.b3d"):PositionEntity m_palm4,0,-5000,0:HideEntity m_palm4:ClearTextureFilters
Global m_palm5=LoadMesh("models\palm5.b3d"):PositionEntity m_palm5,0,-5000,0:HideEntity m_palm5
Global m_palm6=LoadMesh("models\palm6.b3d"):PositionEntity m_palm6,0,-5000,0:HideEntity m_palm6
Global m_drytree=LoadMesh("models\drytree.b3d"):PositionEntity m_drytree,0,-5000,0:HideEntity m_drytree
TextureFilter "",4:Global m_bush1=LoadMesh("models\bush1.b3d"):PositionEntity m_bush1,0,-5000,0:HideEntity m_bush1:ClearTextureFilters
TextureFilter "",4:Global m_bush1b=LoadMesh("models\bush1b.b3d"):PositionEntity m_bush1b,0,-5000,0:HideEntity m_bush1b:ClearTextureFilters
TextureFilter "",4:Global m_bush1c=LoadMesh("models\bush1c.b3d"):PositionEntity m_bush1c,0,-5000,0:HideEntity m_bush1c:ClearTextureFilters
TextureFilter "",4:Global m_bush2=LoadMesh("models\bush2.b3d"):PositionEntity m_bush2,0,-5000,0:HideEntity m_bush2:ClearTextureFilters
Global m_bush3=LoadMesh("models\bush3.b3d"):PositionEntity m_bush3,0,-5000,0:HideEntity m_bush3
TextureFilter "",4:Global m_bush4=LoadMesh("models\bush4.b3d"):PositionEntity m_bush4,0,-5000,0:HideEntity m_bush4:ClearTextureFilters
TextureFilter "",4:Global m_bush5=LoadMesh("models\bush5.b3d"):PositionEntity m_bush5,0,-5000,0:HideEntity m_bush5:ClearTextureFilters
TextureFilter "",2:Global m_corn=LoadMesh("models\corn.b3d"):PositionEntity m_corn,0,-5000,0:HideEntity m_corn:ClearTextureFilters
TextureFilter "",2:Global m_hemp=LoadMesh("models\hemp.b3d"):PositionEntity m_hemp,0,-5000,0:HideEntity m_hemp:ClearTextureFilters
Global m_stone1=LoadMesh("models\stone1.3ds"):RotateMesh m_stone1,-90,0,0:PositionEntity m_stone1,0,-5000,0:HideEntity m_stone1
Global m_stone2=LoadMesh("models\stone2.3ds"):RotateMesh m_stone2,-90,0,0:PositionEntity m_stone2,0,-5000,0:HideEntity m_stone2
TextureFilter "",2:Global m_gras=LoadMesh("models\gras.b3d"):PositionEntity m_gras,0,-5000,0:HideEntity m_gras:ClearTextureFilters
TextureFilter "",4:Global m_flowers=LoadMesh("models\flowers.b3d"):PositionEntity m_flowers,0,-5000,0:HideEntity m_flowers:ClearTextureFilters
TextureFilter "",4:Global m_flowers2=LoadMesh("models\flowers2.b3d"):PositionEntity m_flowers2,0,-5000,0:HideEntity m_flowers2:ClearTextureFilters
TextureFilter "",4:Global m_flowers3=LoadMesh("models\flowers3.b3d"):PositionEntity m_flowers3,0,-5000,0:HideEntity m_flowers3:ClearTextureFilters
TextureFilter "",4:Global m_flowers4=LoadMesh("models\flowers4.b3d"):PositionEntity m_flowers4,0,-5000,0:HideEntity m_flowers4:ClearTextureFilters
TextureFilter "",4:Global m_lionstone=LoadMesh("models\lionstone.b3d"):PositionEntity m_lionstone,0,-5000,0:HideEntity m_lionstone:ClearTextureFilters
Global m_eggs=LoadMesh("models\eggs.b3d"):PositionEntity m_eggs,0,-5000,0:HideEntity m_eggs
TextureFilter "",4:Global m_tree1=LoadMesh("models\tree1.b3d"):PositionEntity m_tree1,0,-5000,0:HideEntity m_tree1:ClearTextureFilters
Global m_shell=LoadMesh("models\shell.3ds"):RotateMesh m_shell,-90,0,0:PositionEntity m_shell,0,-5000,0:HideEntity m_shell
Global m_seastar=LoadMesh("models\seastar.3ds"):RotateMesh m_seastar,-90,0,0:PositionEntity m_seastar,0,-5000,0:HideEntity m_seastar
Global m_turtle=LoadAnimMesh("models\turtle.b3d"):PositionEntity m_turtle,0,-5000,0:HideEntity m_turtle
Global m_cancer=LoadAnimMesh("models\cancer.b3d"):PositionEntity m_cancer,0,-5000,0:HideEntity m_cancer
Global m_flower=LoadMesh("models\flower.3ds"):RotateMesh m_flower,-90,0,0:PositionEntity m_flower,0,-5000,0:HideEntity m_flower
Global m_butterfly=LoadAnimMesh("models\butterfly.b3d"):PositionEntity m_butterfly,0,-5000,0:HideEntity m_butterfly
TextureFilter "",4:Global m_lion=LoadAnimMesh("models\lion.b3d"):PositionEntity m_lion,0,-5000,0:HideEntity m_lion:ClearTextureFilters
Global m_oldman=LoadAnimMesh("models\oldman.b3d"):PositionEntity m_oldman,0,-5000,0:HideEntity m_oldman
Global m_shark=LoadMesh("models\shark.3ds"):RotateMesh m_shark,-90,0,0:PositionEntity m_shark,0,-5000,0:HideEntity m_shark
Global m_kiwi=LoadMesh("models\kiwi.b3d"):PositionEntity m_kiwi,0,-5000,0:HideEntity m_kiwi
Global m_raptor=LoadAnimMesh("models\raptor.b3d"):PositionEntity m_raptor,0,-5000,0:HideEntity m_raptor
Global m_soldier=LoadMesh("models\soldier.b3d"):PositionEntity m_soldier,0,-5000,0:HideEntity m_soldier
Global m_native=LoadAnimMesh("models\native.b3d"):PositionEntity m_native,0,-5000,0:HideEntity m_native
Global m_bird=LoadMesh("models\bird.b3d"):PositionEntity m_bird,0,-5000,0:HideEntity m_bird
Global m_item_ast=LoadMesh("models\item_ast.3ds"):RotateMesh m_item_ast,-90,0,0:PositionEntity m_item_ast,0,-5000,0:HideEntity m_item_ast
Global m_item_leaf=LoadMesh("models\item_leaf.3ds"):RotateMesh m_item_leaf,-90,0,0:PositionEntity m_item_leaf,0,-5000,0:HideEntity m_item_leaf
Global m_item_stone=LoadMesh("models\item_stone.3ds"):RotateMesh m_item_stone,-90,0,0:PositionEntity m_item_stone,0,-5000,0:HideEntity m_item_stone
Global m_item_trunk=LoadMesh("models\item_trunk.3ds"):RotateMesh m_item_trunk,-90,0,0:PositionEntity m_item_trunk,0,-5000,0:HideEntity m_item_trunk
Global m_item_flesh=LoadMesh("models\item_flesh.b3d"):PositionEntity m_item_flesh,0,-5000,0:HideEntity m_item_flesh
Global m_item_smallflesh=LoadMesh("models\item_smallflesh.b3d"):PositionEntity m_item_smallflesh,0,-5000,0:HideEntity m_item_smallflesh
Global m_item_box=LoadMesh("models\item_box.3ds"):RotateMesh m_item_box,-90,0,0:PositionEntity m_item_box,0,-5000,0:HideEntity m_item_box
TextureFilter "",4:Global m_building=LoadMesh("models\building.3ds"):RotateMesh m_building,-90,0,0:PositionEntity m_building,0,-5000,0:HideEntity m_building:ClearTextureFilters
TextureFilter "",4:Global m_house=LoadMesh("models\house.b3d"):PositionEntity m_house,0,-5000,0:HideEntity m_house:ClearTextureFilters
TextureFilter "",4:Global m_treehouse=LoadMesh("models\treehouse.b3d"):PositionEntity m_treehouse,0,-5000,0:HideEntity m_treehouse:ClearTextureFilters
Global m_fire=LoadMesh("models\fire.b3d"):PositionEntity m_fire,0,-5000,0:HideEntity m_fire
Global m_boat=LoadMesh("models\boat.b3d"):PositionEntity m_boat,0,-5000,0:HideEntity m_boat
Global m_wreck=LoadMesh("models\shipwreck.b3d"):PositionEntity m_wreck,0,-5000,0:HideEntity m_wreck
Global m_spear=LoadMesh("models\spear.b3d"):PositionEntity m_spear,0,-5000,0:HideEntity m_spear
Global m_torch=LoadMesh("models\torch.b3d"):PositionEntity m_torch,0,-5000,0:HideEntity m_torch
Global m_storage=LoadMesh("models\foodstorage.b3d"):PositionEntity m_storage,0,-5000,0:HideEntity m_storage
TextureFilter "",4:Global m_reuse=LoadMesh("models\reuse.b3d"):PositionEntity m_reuse,0,-5000,0:HideEntity m_reuse:ClearTextureFilters
TextureFilter "",4:Global m_finish=LoadMesh("models\finish.b3d"):PositionEntity m_finish,0,-5000,0:HideEntity m_finish:ClearTextureFilters
TextureFilter "",4:Global m_checkp=LoadMesh("models\checkpoint.b3d"):PositionEntity m_checkp,0,-5000,0:HideEntity m_checkp:ClearTextureFilters
TextureFilter "",4:Global m_kiwip=LoadMesh("models\kiwipoint.b3d"):PositionEntity m_kiwip,0,-5000,0:HideEntity m_kiwip:ClearTextureFilters
Global m_wall=LoadMesh("models\wall.b3d"):PositionEntity m_wall,0,-5000,0:HideEntity m_wall
TextureFilter "",4:Global m_wallc=LoadMesh("models\wallcorner.b3d"):PositionEntity m_wallc,0,-5000,0:HideEntity m_wallc:ClearTextureFilters
Global m_cammo=LoadMesh("models\crate_ammo.b3d"):PositionEntity m_cammo,0,-5000,0:HideEntity m_cammo
Global m_cpistol=LoadMesh("models\crate_pistol.b3d"):PositionEntity m_cpistol,0,-5000,0:HideEntity m_cpistol
Global m_cak=LoadMesh("models\crate_ak.b3d"):PositionEntity m_cak,0,-5000,0:HideEntity m_cak
Global m_spikes=LoadMesh("models\spikewall.b3d"):PositionEntity m_spikes,0,-5000,0:HideEntity m_spikes
Global m_arrow=LoadMesh("models\arrow.b3d"):PositionEntity m_arrow,0,-5000,0:HideEntity m_arrow
Global m_smallstake=LoadMesh("models\smallstake.b3d"):PositionEntity m_smallstake,0,-5000,0:HideEntity m_smallstake
Global m_stake=LoadMesh("models\stake.b3d"):PositionEntity m_stake,0,-5000,0:HideEntity m_stake

;Sprites
Global s_starflare=LoadSprite("gfx/starflare.bmp"):PositionEntity  s_starflare,0,-5000,0:HideEntity s_starflare
Global s_lightflare=LoadSprite("gfx/lightflare.bmp"):PositionEntity s_lightflare,0,-5000,0:HideEntity s_lightflare
Global s_fire=LoadSprite("gfx/fire.bmp"):PositionEntity s_fire,0,-5000,0:HideEntity s_fire

;Temporary
Global tempimg




;-----Sfx
load_screen("Loading Sounds", 5)

;Birds
Dim sfx_bird(4)
For i=1 To 5
	sfx_bird(i-1) = LoadSound("sfx/bird"+i+".wav")
Next

;Lion
Global sfx_lion_spot = LoadSound("sfx/lion_spot.wav")
Global sfx_lion_attack = LoadSound("sfx/lion_attack.wav")

;Raptor
Global sfx_raptor_attack = LoadSound("sfx/raptor_attack.wav")
Global sfx_raptor_spot = LoadSound("sfx/raptor_spot.wav")

;Kiwi
Global sfx_kiwi = LoadSound("sfx/kiwi.wav")

;Actions
Dim sfx_woodcut(1)
For i=1 To 2
	sfx_woodcut(i-1) = LoadSound("sfx/act_woodcut"+i+".wav")
Next
Global sfx_fishing = LoadSound("sfx/act_fishing.wav")
Global sfx_build = LoadSound("sfx/act_build.wav")
Global sfx_drink = LoadSound("sfx/act_drink.wav")
Global sfx_action = LoadSound("sfx/act_act.wav")
Global sfx_error = LoadSound("sfx/act_actneg.wav")
Global sfx_schleuder = LoadSound("sfx/act_schleuder.wav")
Global sfx_sleep = LoadSound("sfx/act_sleep.wav")
Global sfx_hack = LoadSound("sfx/act_stonehack.wav")
Global sfx_checkp = LoadSound("sfx/checkpoint.wav")

;Player Movement & Fight
Dim sfx_step(1)
For i=1 To 2
	sfx_step(i-1) = LoadSound("sfx/step"+i+".wav")
Next
Dim sfx_pain(2)
For i=1 To 3
	sfx_pain(i-1) = LoadSound("sfx/pain"+i+".wav")
Next
Global sfx_wosh = LoadSound("sfx/wosh.wav")
Global sfx_swim = LoadSound("sfx/swim.wav")
Global sfx_standup = LoadSound("sfx/standup.wav")
Global sfx_splash = LoadSound("sfx/splash.wav")
Global sfx_land = LoadSound("sfx/land.wav")
Global sfx_die = LoadSound("sfx/die.wav")
Global sfx_skill = LoadSound("sfx/skill.wav")
Global sfx_hitflesh = LoadSound("sfx/hitflesh.wav")
Global sfx_jump = LoadSound("sfx/rubberjump.wav")
Global sfx_ak = LoadSound("sfx/ak.wav")
Global sfx_ak_take = LoadSound("sfx/take_ak.wav")
Global sfx_pistol = LoadSound("sfx/pistol.wav")
Global sfx_pistol_take = LoadSound("sfx/take_pistol.wav")
Global sfx_knife = LoadSound("sfx/knife.wav")
Global sfx_netwosh = LoadSound("sfx/netwosh.wav")

;Environment
Global sfx_bee = LoadSound("sfx/bee.wav")
Global sfx_rain = LoadSound("sfx/rain.wav")
Global sfx_thunder = LoadSound("sfx/thunder.wav")
Global sfx_day = LoadSound("sfx/day.wav")
Global sfx_night = LoadSound("sfx/night.wav")
Global sfx_treefall = LoadSound("sfx/treefall.wav")
Global sfx_fire = LoadSound("sfx/fire.wav")
Global sfx_quelle = LoadSound("sfx/quelle.wav")
Global sfx_waves = LoadSound("sfx/waves.wav")

;GUI
Global sfx_paper = LoadSound("sfx/gui_paper.wav")
Global sfx_pop = LoadSound("sfx/pop.wav")

;Track
Global sfx_track_menu = LoadSound("sfx/track_menu.mp3")
Global sfx_track_credits = LoadSound("sfx/track_credits.mp3")
Global sfx_track_gameover = LoadSound("sfx/track_gameover.mp3")
Global sfx_track_won = LoadSound("sfx/track_won.mp3")
Global sfx_track_high = LoadSound("sfx/track_high.mp3")

Global sfx_chan
Global sfx_random
Global sfx_track
Global sfx_env
Global sfx_gmtrack













;-----Objekte
load_screen("Loading Objects", 5)

;Pivot
Global pivot=CreatePivot()
EntityType pivot,ct_player
EntityRadius pivot,3
PositionEntity pivot, 0,0,0

;Climb Pivot
Global cpivot=CreatePivot()
EntityType cpivot,ct_player
EntityRadius cpivot,1
PositionEntity cpivot, 0,-2,0
EntityParent cpivot, pivot

;Muzzle Flash
Global mflasht
Global mflash=CreateLight(2)
EntityParent mflash, pivot
LightColor mflash, 255,255,0
LightRange mflash, 10
HideEntity mflash


Include "includes/bloomfilter.bb"

;Camera
Global camera
Global camera_x#=0
Global camera_y#=0
Global camera_z#=0
camera=CreateCamera()
CameraFogColor camera, 100,150,200
CameraFogMode camera, 1
CameraFogRange camera, 5, opt_range
CameraRange camera, 1, opt_range*1.5+30
InitGlow camera, 0,0,opt_sx,opt_sy
HideEntity GL_sprite_scene

;Kompass
Global gui_kompass
Global gui_kompass_z
gui_kompass=LoadSprite ("gfx\gui_kompass.bmp",4,camera)
EntityOrder gui_kompass,-4
PositionEntity gui_kompass, 5-(opt_sx)+70,-5-70+(opt_sy), opt_sx
ScaleSprite gui_kompass,70,70
EntityFX gui_kompass, 9
EntityParent gui_kompass, camera
gui_kompass_z=LoadSprite("gfx\gui_kompass_z.bmp",4,camera)
EntityOrder gui_kompass_z,-5
PositionEntity gui_kompass_z, 5-(opt_sx)+70,-5-70+(opt_sy), opt_sx
ScaleSprite gui_kompass_z,70,70
EntityFX gui_kompass_z, 9
EntityParent gui_kompass_z, camera

;Boden
Global earth
earth=CreatePlane()
SetCubeFace gfx_sand,4
PositionEntity earth, 0, -0.1, 0
EntityTexture earth, gfx_sand
ScaleTexture gfx_sand, 150,150
EntityType earth,ct_flora
EntityPickMode earth, 2,1

;Water
Global water
Global watero#
Global watero2#
Global waterz#=0.5
Global watermode=0
Global wet
Global wetalpha#=0
TextureBlend gfx_water2,3
ScaleTexture gfx_water2,60,60
TextureBlend gfx_water3,3
ScaleTexture gfx_water3,70,70
water=CreatePlane(10)
;EntityShininess water,1
EntityTexture water, gfx_water,0,0
EntityTexture water, gfx_water2,0,1
EntityTexture water, gfx_water3,0,2
PositionEntity water, 0, waterz#, 0
wet=CopyEntity(water)
EntityAlpha wet, wetalpha#
PositionEntity wet, 0, 1.5, 0

;Sky
Global sky
Global sky_pos#
Global sky_color#
Global switch_sky_color#=0.05
sky=CreateSphere(10)
EntityTexture sky,gfx_sky
EntityColor sky, 170,220,250
FlipMesh sky
ScaleEntity sky,650,650,650
EntityFX sky,9
EntityOrder sky,10

;Terrain (noch nicht anlegen)
Global terrain

;Lensflares
Global lens_flares = CreatePivot(camera)
PositionEntity lens_flares, -1, (opt_sy/opt_sx), 1
scale# = 2.0/opt_sx
ScaleEntity lens_flares, scale, -scale, scale
Global lens_sun = CreatePivot()
PositionEntity lens_sun, 0,10,0
Dim lens_flare(5)
Dim lens_dist#(5)
lens_flare(0)=LoadSprite("gfx/lens1.jpg"): EntityParent lens_flare(0),lens_flares: EntityFX lens_flare(0),8: ScaleSprite lens_flare(0),0.3,0.3 : EntityAlpha lens_flare(0),1 : lens_dist(0)=1
lens_flare(1)=LoadSprite("gfx/lens2.jpg"): EntityParent lens_flare(1),lens_flares: EntityFX lens_flare(1),8: ScaleSprite lens_flare(1),0.3,0.3 : EntityAlpha lens_flare(1),1 : lens_dist(1)=3
lens_flare(2)=LoadSprite("gfx/lens3.jpg"): EntityParent lens_flare(2),lens_flares: EntityFX lens_flare(2),8: ScaleSprite lens_flare(2),0.3,0.3 : EntityAlpha lens_flare(2),1 : lens_dist(2)=4
lens_flare(3)=LoadSprite("gfx/lens4.jpg"): EntityParent lens_flare(3),lens_flares: EntityFX lens_flare(3),8: ScaleSprite lens_flare(3),0.3,0.3 : EntityAlpha lens_flare(3),1 : lens_dist(3)=6
lens_flare(4)=CopyEntity(lens_flare(2)): EntityParent lens_flare(4),lens_flares: EntityFX lens_flare(4),8: ScaleSprite lens_flare(4),0.3,0.3 : EntityAlpha lens_flare(4),0.7 : lens_dist(4)=10
lens_flare(5)=CopyEntity(lens_flare(1)): EntityParent lens_flare(5),lens_flares: EntityFX lens_flare(5),8: ScaleSprite lens_flare(5),0.3,0.3 : EntityAlpha lens_flare(5),0.5 : lens_dist(5)=12
Global sun_light = CreateLight(1,lens_sun)
PointEntity sun_Light,pivot

;Lichtsprite
Global lspr
Global lspr_alpha#
Global lspr_fade#
lspr=CreateCube()
ScaleEntity lspr, 8,8,1
EntityTexture lspr, gfx_dummy
EntityParent lspr, camera
MoveEntity lspr, 4,4,4
EntityOrder lspr, -1
EntityAlpha lspr, 0

;Collisions
Collisions ct_player,ct_flora,2,3
Collisions ct_player,ct_fauna,2,3
Collisions ct_player,ct_slide,2,2

;Clear
clear

;Intro abspielen
intro()

ShowEntity GL_sprite_scene


;-----Functions
Function load_screen(info$, speed=10)
	Local strlen, strpix
	strlen=Len(info$)
	strpix=StringWidth(info$)/2
	SetFont font_norm
	Color 255,255,255
	Cls
	DrawBlock gfx_icon, opt_sx/2-ImageWidth(gfx_icon)/2,  opt_sy/2-ImageHeight(gfx_icon)/2
	Text opt_sx/2-strpix, opt_sy/2+5+ImageHeight(gfx_icon)/2, info$
	DrawBlock gfx_wait, opt_sx/2, opt_sy/2+90
	Flip
	Delay speed
	For i=0 To strlen
		Cls
		Color 255,255,255
		DrawBlock gfx_icon, opt_sx/2-ImageWidth(gfx_icon)/2,  opt_sy/2-ImageHeight(gfx_icon)/2
		Text opt_sx/2-strpix, opt_sy/2+5+ImageHeight(gfx_icon)/2, info$
		Color 80,255,80
		Text opt_sx/2-strpix, opt_sy/2+5+ImageHeight(gfx_icon)/2, Left(info$, i)
		DrawBlock gfx_wait, opt_sx/2, opt_sy/2+90
		Flip
		Delay speed
	Next
End Function