;-----Functions

;Intro
Function intro()
	Local unso, unso2
	Local timer
	Local alpha#
	Local ms
	Local sound
	Local light
	HideEntity earth
	HideEntity water
	HideEntity sky
	HideEntity gui_kompass
	HideEntity gui_kompass_z
	For i = 0 To 5
		HideEntity lens_flare(i) 
	Next
	sound=LoadSound("sfx/unrealsoftware.mp3")
	unso=LoadSprite("gfx/unrealsoftware.bmp", 4)
	ScaleSprite unso,300,30
	EntityAlpha unso,0
	PositionEntity unso,0,0,opt_sx/2
	alpha#=0
	timer=0
	ms=MilliSecs()
	FlushKeys
	FlushMouse
	CameraRange camera, 1, (opt_sx/2)+1000
	CameraFogMode camera, 0
	PlaySound sound
	While timer<450
		If MilliSecs()-ms>=10
			ms=MilliSecs()
			timer=timer+1
			If timer>50 And timer<150 Then
				alpha#=alpha#+0.01
				EntityAlpha unso, alpha#
			EndIf
			If timer>220 And timer<320 Then
				alpha#=alpha#-0.01
				EntityAlpha unso, alpha#
			EndIf
		EndIf
		Cls
		RenderWorld
		Flip
		If GetKey()>0 Then timer=450
		If GetMouse()>0 Then timer=450
	Wend
	FreeEntity unso
	FreeSound sound
	CameraFogMode camera, 1
	ShowEntity earth
	ShowEntity water
	ShowEntity sky
End Function

;Beenden
Function quit(quick=0)
	FlushKeys
	FlushMouse
	If quick=1 Then End
	Local cachesfx, cachegfx, ms
	cachesfx=LoadSound("sfx/quit.wav")
	cachegfx=LoadImage("gfx/b3dlogo.jpg")
	MidHandle cachegfx
	StopChannel sfx_chan
	PlaySound cachesfx
	ms=MilliSecs()
	While MilliSecs()-ms<3000
		Cls
		SetFont font_menu
		Color 255,255,255
		Text opt_sx/2,opt_sy/2-82, "Stranded wurde programmiert in",1,1
		DrawImage cachegfx, opt_sx/2,opt_sy/2
		Text opt_sx/2,opt_sy/2+82, "THX 4 Playing!",1,1
		If GetKey()>0 Then ms=0
		If MouseHit(1) Or MouseHit(2) Then ms=0
		Flip
	Wend
	End
End Function

;Lschen
Function clear()
	load_screen("Loading", 5)
	;Camera
	CameraZoom camera, 1
	;Terrain lschen
	If terrain Then
		FreeEntity terrain
		terrain=0
	EndIf
	;Floras lschen
	For flora.flora = Each flora
		FreeEntity flora\h
		Delete flora
	Next
	;Faunas lschen
	For fauna.fauna = Each fauna
		FreeEntity fauna\h
		Delete fauna
	Next
	;Buildings lschen
	For building.building = Each building
		FreeEntity building\h1
		If building\h2<>0 Then FreeEntity building\h2
		If building\h3<>0 Then FreeEntity building\h3
		Delete building
	Next
	;Statics lschen
	For static.static = Each static
		FreeEntity static\h
		Delete static
	Next
	;Effects lschen
	For effect.effect = Each effect
		If effect\h <>0 Then FreeEntity effect\h
		Delete effect
	Next
	;Item lschen
	For item.item = Each item
		FreeEntity item\h
		Delete item
	Next
	;Lightsprite reseten
	EntityAlpha lspr, 0
	;Sky positionieren
	PositionEntity sky, 0,0,0
	;Kompass hiden
	HideEntity gui_kompass
	HideEntity gui_kompass_z
	;Muzzle Flash aus
	HideEntity mflash
	mflasht=0
	;Lensflares hiden
	For i = 0 To 5
		HideEntity lens_flare(i) 
	Next
	;Grid weg
	If grid=1 Then grid()
	;Licht
	updatelight(150)
	;Map
	For x=0 To msz
		For y=0 To msz
			mapfree(x,y)=0
		Next
	Next
	;Editor
	For i=0 To 3
		If ed_h(i)<>0 Then
			FreeEntity ed_h(i)
			ed_h(i)=0
		EndIf
	Next
	;Engine Variablen lschen
	mxs#=0
	mys#=0
	mx=0
	my=0
	md=0
	mh=0
	ms=0
	timer1=0
	timer2=0
	timer3=0
	timer_gui=0
	timer_gui_run=0
	timer_waves=0
	gamestop=0
	pause=0
	script=0
	script_timer=0
	script_timer2=0
	script_icon=0
	multidown=0
	enter$=0
	rendertime=0
	x=0
	y=0
	z=0
	i=0
	;GUI Variablen lschen
	gui_selinput=0
	Dim gui_checkb(30)
	Dim gui_input$(30)
	;Game Variablen lschen
	gm_custom=0
	gm_arcade=0
	gm_time=0
	gm_time_ms=0
	gm_rain=0
	gm_infinitespear=0
	gm_infiniteammo=0
	gm_frozentime=0
	gm_texture$=0
	gm_checkp=0
	gm_kiwis=0
	Dim gm_killed(30)
	Dim gm_mi_kill(30)
	gm_mi_checkp=0
	gm_mi_kiwis=0
	gm_mi_finish=0
	gm_mi_distance=5000
	Dim gm_cm$(30)
	gm_briefing$=""
	gm_track$=""
	If sfx_gmtrack<>0 Then FreeSound sfx_gmtrack
	sfx_gmtrack=0
	;Tools
	tl_knife=0
	tl_ak=0
	tl_pistol=0
	tl_netz=0
	tl_speer=0
	tl_angel=0
	tl_axt=0
	tl_hammer=0
	tl_stnschl=0
	;Player Variablen lschen
	pl_health=0
	pl_health_max=0
	pl_health_up=0
	pl_health_cache=0
	pl_power=0
	pl_power_up=0	
	pl_tired=0
	pl_hunger=0
	pl_thirst=0
	pl_hi=0
	pl_jumpmode=0
	pl_jumpspeed#=0
	pl_fallspeed#=0
	pl_walk=0
	pl_multimove=0
	pl_down=0
	pl_tilex=0
	pl_tiley=0
	pl_tilebuild=0
	pl_tilebuildr=0
	pl_tilebuildb=0
	pl_tileflora=0
	pl_tilefauna=0
	pl_action$=0
	pl_actionakt=0
	pl_actiontotal=0
	pl_tool=0
	pl_toolakt=0
	pl_tooltotal=1
	pl_toolmsg$=0
	pl_drive=0
	pl_driveh=0
	pl_driveacc#=0
	pl_quest=0
	pl_trade=0
	pl_train=0
	pl_rubber=0
	pl_menaction=0
	Dim pl_item(15)
	Dim pl_items(15)
	Dim pl_itemc(15)
	;Spieler
	w_rd=0
	EntityType pivot,ct_player
	EntityType cpivot,ct_player
	EntityRadius pivot,3
	camera_x#=0
	camera_y#=0
	camera_z#=0
	UpdateWorld
End Function

;Game initialisieren
Function game_ini()
	load_screen("Initialing", 5)
	;Einstellen
	AntiAlias opt_alias
	CameraFogMode camera, 1
	CameraFogColor camera, 150,180,200
	CameraFogRange camera, 0, opt_range
	CameraRange camera, 1, 2000
	RotateEntity camera, 0,0,0 : MoveMouse(opt_sx/2,opt_sy/2) : MouseXSpeed() : MouseYSpeed()
	opt_rangeh=opt_range/1.2
	opt_autofade_s=opt_range-30
	opt_autofade_e=opt_range-10
	;GUI
	gui_offset=148
	gui_paperoffset=-opt_sy
	gui_on=0
	gui_messageon=0
	ShowEntity gui_kompass
	ShowEntity gui_kompass_z
End Function

;Game load
Function game_load(name$, dir$="sav")
	Local x#,y#,z#,yaw#,typ, timer, value, health, scale#, datum$, mode, turnmode, age, ha, targetyaw
	If FileType(dir$)=0 Then CreateDir(dir$)
	If FileType(dir$)=0 Then RuntimeError("Ordner ("+dir$+"), konnte nicht angelegt werden!")
	If FileType(dir$+"/"+name$+".sav")=0 Then
		msg("Hier wurde kein Spielstand abgelegt!",1,2)
		Return 0
	EndIf
	clear
	game_ini()
	load_screen("Loading", 5)
	;Standart Textur
	gm_texture="gfx/tex_terrain.bmp"
	;Terrain
	terrain_create()
	;File
	Local file, r
	file=ReadFile(dir$+"/"+name$+".sav")
	ed_map$=name$
	header$=ReadLine(file)
	datum$=ReadLine(file)
	;Terrain
	For x=0 To 256
		For y=0 To 256
			ModifyTerrain(terrain,x,y,ReadFloat(file))
		Next
	Next
	;Win Distanz
	gm_mi_distance=5000
	gm_custom=0
	gm_arcade=0
	;Player
	pl_health=ReadInt(file)
	pl_health_max=ReadInt(file)
	pl_health_up=ReadInt(file)
	pl_power=ReadInt(file)
	pl_power_up=ReadInt(file)
	pl_tired=ReadByte(file)
	pl_hunger=ReadByte(file)
	pl_thirst=ReadByte(file)
	pl_hi=ReadInt(file)
	pl_down=ReadByte(file)
	pl_quest=ReadInt(file)
	pl_rubber=ReadInt(file)
	fake=ReadInt(file)
	fake=ReadInt(file)
	fake=ReadInt(file)
	gm_custom=ReadInt(file)
	x#=ReadFloat(file)
	y#=ReadFloat(file)
	z#=ReadFloat(file)
	c_respawn_x#=x#
	c_respawn_y#=y#
	c_respawn_z#=z#
	c_respawn_timer=5
	PositionEntity(pivot, x#,y#,z#)
	x#=ReadFloat(file)
	y#=ReadFloat(file)
	z#=ReadFloat(file)
	TurnEntity(camera, x#,y#,z#)
	fake=ReadLine(file)
	fake=ReadLine(file)
	fake=ReadLine(file)
	fake=ReadLine(file)
	fake=ReadLine(file)
	;Items
	For i=0 To 15
		pl_item(i)=ReadByte(file)
		pl_itemc(i)=ReadInt(file)
	Next
	;Tools
	tl_speer=ReadByte(file)
	tl_angel=ReadByte(file)
	tl_axt=ReadByte(file)
	tl_hammer=ReadByte(file)
	tl_stnschl=ReadByte(file)
	tl_knife=ReadByte(file)
	tl_ak=ReadByte(file)
	tl_pistol=ReadByte(file)
	tl_netz=ReadByte(file)
	fake=ReadByte(file)
	fake=ReadByte(file)
	fake=ReadByte(file)
	fake=ReadByte(file)
	fake=ReadByte(file)
	;Game Time
	gt_day=ReadShort(file)
	gt_min=ReadByte(file)
	gt_hour=ReadByte(file)
	;Floras
	While ReadByte(file)=0
		x#=ReadInt(file)
		y#=ReadInt(file)
		z#=ReadInt(file)
		yaw#=ReadInt(file)
		typ=ReadByte(file)
		timer=ReadInt(file)
		value=ReadInt(file)
		health=ReadInt(file)
		scale#=ReadFloat(file)
		terrain_flora_add(x#, y#, z#, typ, scale#, yaw#, value, health, timer)
	Wend
	;Faunas
	While ReadByte(file)=0
		x#=ReadFloat(file)
		y#=ReadFloat(file)
		z#=ReadFloat(file)
		yaw#=ReadFloat(file)
		typ=ReadByte(file)
		timer=ReadInt(file)
		mode=ReadByte(file)
		turnmode=ReadByte(file)
		targetyaw=ReadInt(file)
		age=ReadInt(file)
		health=ReadInt(file)
		terrain_fauna_add(x#, y#, z#, typ, yaw#, timer, mode, turnmode, age, health, targetyaw)
	Wend
	;Statics
	While ReadByte(file)=0
		x#=ReadFloat(file)
		y#=ReadFloat(file)
		z#=ReadFloat(file)		
		yaw#=ReadInt(file)
		typ=ReadByte(file)
		terrain_static_add(x#, y#, z#, typ, yaw#)
	Wend
	;Buildings
	While ReadByte(file)=0
		building.building=New building
		x#=ReadInt(file)
		y#=ReadInt(file)
		z#=ReadInt(file)			
		yaw#=ReadInt(file)
		building\typ=ReadByte(file)
		building\mode=ReadInt(file)
		building\req_ast=ReadByte(file)
		building\req_blatt=ReadByte(file)
		building\req_stein=ReadByte(file)
		building\req_liane=ReadByte(file)
		building\req_baumstamm=ReadByte(file)
		building\req_total=ReadByte(file)
		building\value$=ReadLine(file)
		If building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm>0 Then
			building\h1 = CopyMesh(m_building)
			EntityFX building\h1,16
			ScaleEntity building\h1,0.15,0.15,0.15
			building\h2 = CreatePivot()
			building\h3 = CreatePivot()
			PositionEntity building\h1, x#,y#,z#
		Else
			terrain_building_add(x#,y#,z#, building\typ, 0, building\mode, 0, yaw#, building\value$)
			Delete building
		EndIf
	Wend
	;Items
	While ReadByte(file)=0
		x#=ReadInt(file)
		y#=ReadInt(file)
		z#=ReadInt(file)
		typ=ReadByte(file)
		timer=ReadInt(file)
		age=ReadInt(file)
		item_set(x#, z#, typ, 0, y#, timer, age)
	Wend
	;Custom Game
	If gm_custom<>0 Then
		gm_briefing$=ReadLine(file)
		gm_arcade=ReadByte(file)
		gm_time=ReadInt(file)
		gm_rain=ReadByte(file)
		gm_infinitespear=ReadByte(file)
		gm_infiniteammo=ReadByte(file)
		gm_frozentime=ReadByte(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		fake=ReadInt(file)
		gm_checkp=ReadInt(file)
		gm_kiwis=ReadInt(file)
		For i=0 To 30
			gm_killed(i)=ReadShort(file)
		Next
		For i=0 To 30
			gm_mi_kill(i)=ReadShort(file)
		Next
		gm_mi_checkp=ReadInt(file)
		gm_mi_kiwis=ReadInt(file)
		gm_mi_finish=ReadByte(file)
		gm_mi_distance=ReadInt(file)
		gm_texture$=ReadLine(file)
		gm_track$=ReadLine(file)
		gm_floortex$=ReadLine(file)
		gm_skytex$=ReadLine(file)
		gm_skyrot#=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
		fake=ReadLine(file)
	EndIf
	;Texture
	FreeTexture gfx_terrain
	If FileType(gm_texture$)<>1 Then RuntimeError("Die Textur "+gm_texture$+" konnte nicht geladen werden!")
	gfx_terrain = LoadTexture (gm_texture$)
	ScaleTexture gfx_terrain, 256, 256
	EntityTexture terrain, gfx_terrain
	;Track
	sfx_gmtrack=0
	If gm_track$<>"" Then
		If FileType(gm_track$)=1 Then
			sfx_gmtrack=LoadSound(gm_track$)
		EndIf
	EndIf
	;Close
	CloseFile file
	;Output
	Dim gui_msg$(5)
	Dim gui_msgt(5)
	Dim gui_msgc(5)
	If dir$="sav" Then msg("Spielstand vom "+datum$+" wurde geladen!",1,1)
	;Custom Message
	If dir$="sav" Then gm_briefing$=""
	;Other
	scantile()
	Return 1
End Function

;Game save
Function game_save(name$, win=1, dir$="sav")
	If pl_drive=1 Then msg("Du kannst nicht speichern whrend du Flo fhrst!",1,2): Return 0
	If FileType(dir$)=0 Then CreateDir(dir$)
	If FileType(dir$)=0 Then RuntimeError("Ordner ("+dir$+"), konnte nicht angelegt werden!")
	If win=1 Then load_screen("Saving", 5)
	Local file, r
	file=WriteFile(dir$+"/"+name$+".sav")
	;Header
	WriteLine file, "Stranded "+version$+" Savegame"
	WriteLine file, (CurrentDate()+" "+CurrentTime())
	;Terrain
	For x=0 To 256
		For y=0 To 256
			WriteFloat(file),TerrainHeight(terrain,x,y)
		Next
	Next
	;Player
	WriteInt file, pl_health
	WriteInt file, pl_health_max
	WriteInt file, pl_health_up
	WriteInt file, pl_power
	WriteInt file, pl_power_up
	WriteByte file, pl_tired
	WriteByte file, pl_hunger
	WriteByte file, pl_thirst
	WriteInt file, pl_hi
	WriteByte file, pl_down
	WriteInt file, pl_quest
	WriteInt file, pl_rubber
	WriteInt file, fake
	WriteInt file, fake
	WriteInt file, fake
	WriteInt file, gm_custom
	WriteFloat file, EntityX(pivot)
	WriteFloat file, EntityY(pivot)
	WriteFloat file, EntityZ(pivot)
	WriteFloat file, EntityPitch(camera)
	WriteFloat file, EntityYaw(camera)
	WriteFloat file, EntityRoll(camera)
	WriteLine file, fake
	WriteLine file, fake
	WriteLine file, fake
	WriteLine file, fake
	WriteLine file, fake
	;Items
	For i=0 To 15
		WriteByte file, pl_item(i)
		WriteInt file, pl_itemc(i)
	Next
	;Tools
	WriteByte file, tl_speer
	WriteByte file, tl_angel
	WriteByte file, tl_axt
	WriteByte file, tl_hammer
	WriteByte file, tl_stnschl
	WriteByte file, tl_knife
	WriteByte file, tl_ak
	WriteByte file, tl_pistol
	WriteByte file, tl_netz
	WriteByte file, fake
	WriteByte file, fake
	WriteByte file, fake
	WriteByte file, fake
	WriteByte file, fake
	;Game Time
	WriteShort file, gt_day
	WriteByte file, gt_min
	WriteByte file, gt_hour
	;Floras
	For t.flora = Each flora
		WriteByte file, 0
		WriteInt file, EntityX(t\h)
		WriteInt file, EntityY(t\h)
		WriteInt file, EntityZ(t\h)
		WriteInt file, EntityYaw(t\h) 
		WriteByte file, t\typ
		WriteInt file, t\timer
		WriteInt file, t\value
		WriteInt file, t\health
		WriteFloat file, t\scale#
	Next
	WriteByte file, 1
	;Faunas
	For t2.fauna = Each fauna
		WriteByte file, 0
		WriteFloat file, EntityX(t2\h)
		WriteFloat file, EntityY(t2\h)
		WriteFloat file, EntityZ(t2\h)
		WriteFloat file, EntityYaw(t2\h)
		WriteByte file, t2\typ
		WriteInt file, t2\timer
		WriteByte file, t2\mode
		WriteByte file, t2\turnmode
		WriteInt file, t2\targetyaw
		WriteInt file, t2\age
		WriteInt file, t2\health
	Next
	WriteByte file, 1
	;Statics
	For t3.static = Each static
		WriteByte file, 0
		WriteFloat file, EntityX(t3\h)
		WriteFloat file, EntityY(t3\h)
		WriteFloat file, EntityZ(t3\h)
		WriteInt file, EntityYaw(t3\h)
		WriteByte file, t3\typ
	Next
	WriteByte file, 1
	;Buildings
	For t4.building = Each building
		WriteByte file, 0
		WriteInt file, EntityX(t4\h1)
		WriteInt file, EntityY(t4\h1)
		WriteInt file, EntityZ(t4\h1)
		WriteInt file, EntityYaw(t4\h1)
		WriteByte file, t4\typ
		WriteInt file, t4\mode
		WriteByte file, t4\req_ast
		WriteByte file, t4\req_blatt
		WriteByte file, t4\req_stein
		WriteByte file, t4\req_liane
		WriteByte file, t4\req_baumstamm
		WriteByte file, t4\req_total
		WriteLine file, t4\value$
	Next
	WriteByte file, 1
	;Items
	For t5.item = Each item
		WriteByte file, 0
		WriteInt file, EntityX(t5\h)
		WriteInt file, EntityY(t5\h)
		WriteInt file, EntityZ(t5\h)
		WriteByte file, t5\typ
		WriteInt file, t5\timer
		WriteInt file, t5\age
	Next
	WriteByte file, 1
	;Custom Game
	If gm_custom<>0 Then
		WriteLine(file), gm_briefing$
		WriteByte(file), gm_arcade
		WriteInt(file), gm_time
		WriteByte(file),gm_rain
		WriteByte(file),gm_infinitespear
		WriteByte(file),gm_infiniteammo
		WriteByte(file),gm_frozentime
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file), fake
		WriteInt(file),gm_checkp
		WriteInt(file),gm_kiwis
		For i=0 To 30
			WriteShort(file),gm_killed(i)
		Next
		For i=0 To 30
			WriteShort(file),gm_mi_kill(i)
		Next
		WriteInt(file),gm_mi_checkp
		WriteInt(file),gm_mi_kiwis
		WriteByte(file),gm_mi_finish
		WriteInt(file),gm_mi_distance
		WriteLine(file),gm_texture$
		WriteLine(file),gm_track$
		WriteLine(file),gm_floortex$
		WriteLine(file),gm_skytex$
		WriteLine(file),gm_skyrot#
		WriteLine(file), fake
		WriteLine(file), fake
		WriteLine(file), fake
		WriteLine(file), fake
		WriteLine(file), fake
		WriteLine(file), fake
		WriteLine(file), fake
	EndIf
	;Close
	CloseFile file
	msg("Spielstand wurde gespeichert!",1,1)
	Return 1
End Function

;Game New
Function game_new()
	clear()
	game_ini()
	;Texture
	FreeTexture gfx_terrain
	gfx_terrain = LoadTexture ("gfx/tex_terrain.bmp")
	ScaleTexture gfx_terrain, 256, 256
	;Terrain
	terrain_create()
	;Spezielle Sachen
	;Hanf-Feld
	For x=69 To 71
		For y=69 To 71
			terrain_flora_add(x*15, 10, y*15, 21)
		Next
	Next
	;Hanf-Opa
	terrain_fauna_add(70*15, 10, 70*15, 6)
	;Eingeborener
	terrain_fauna_add(20*15, 10, 70*15, 11)
	;Pfahl
	terrain_building_add(19*15, 10, 70*15, 32)
	;Schiffswrack
	terrain_building_add(-70,0,-70, 20)
	;Schiffswrack -> Messer
	item_set(-70, -70, 208, 0)
	;Flora
	load_screen("Pflanzen werden erstellt", speed=5)
	terrain_flora(8000)
	e_flora.flora=First flora
	;Fauna
	load_screen("Tiere werden erstellt", speed=5)
	terrain_fauna(1000)
	e_fauna.fauna=First fauna
	;Statics
	terrain_static(1000)
	e_static.static=First static
	;Spielerwerte
	pl_health=35
	pl_health_max=100
	pl_health_up=0
	pl_power=10
	pl_power_up=0
	pl_tired=25
	pl_hunger=50
	pl_thirst=50
	;Zeit
	gt_day=1
	gt_hour=9
	gt_min=56
	;Spieler positionieren
	PositionEntity pivot, 95, 5, 50
	TurnEntity camera, 0,-20,0
	c_respawn_x#=95
	c_respawn_y#=5
	c_respawn_z#=50
	c_respawn_timer=5
	;Script ausfhren
	script_run(1)
End Function

;Game Editor
Function game_editor()
	clear()
	game_ini()
	HideEntity gui_kompass
	HideEntity gui_kompass_z
	;Texture
	FreeTexture gfx_terrain
	gfx_terrain = LoadTexture ("gfx/tex_terrain.bmp")
	ScaleTexture gfx_terrain, 256, 256
	;Terrain
	terrain_create()
	;Spielerwerte
	pl_health=100
	pl_health_max=100
	pl_health_up=0
	pl_power=10
	pl_power_up=0
	pl_tired=0
	pl_hunger=0
	pl_thirst=0
	;Zeit
	gt_day=1
	gt_hour=6
	gt_min=0
	;Game
	gm_custom=1
	gm_arcade=0
	gm_time=0
	gm_time_ms=0
	gm_rain=0
	gm_infinitespear=0
	gm_infiniteammo=0
	gm_frozentime=0
	gm_texture$="gfx/tex_terrain.bmp"
	;Game - Cache
	gm_checkp=0
	gm_kiwis=0
	Dim gm_killed(30)
	;Game - Missions Ziele
	Dim gm_mi_kill(30)
	gm_mi_checkp=0
	gm_mi_kiwis=0
	gm_mi_finish=0
	gm_mi_distance=5000
	;Editor Einstellen
	ed_select(0,1)
	ed_select(1,1)
	ed_select(2,1)
	ed_select(3,1)
	ed_map$=""
	;Grid an
	grid()
	;Minimap generieren
	ed_minimap()
End Function

;GUI Button zeichnen
Function gui_button(x,y,label$, off=0, col=0)
	over=0
	If off=0 Then
		If my>=gui_my+y Then
			If my<=gui_my+y+14 Then
				If mx>=gui_mx+x Then
					If mx<=gui_mx+x+StringWidth(label$) Then
						over=1
					EndIf
				EndIf
			EndIf
		EndIf
		If over Then
			Color 100,255,100
		Else
			If col=0 Then
				Color 0,0,0
			Else
				Color 255,255,255
			EndIf
		EndIf
	Else
		Color 50,25,0
	EndIf
	Text gui_mx+x, gui_my+y, label$
	If over Then
		Return mh
	Else
		Return 0
	EndIf
End Function

;GUI Checkbox
Function gui_check(x,y,label$,id)
	over=0
	If my>=gui_my+y Then
		If my<=gui_my+y+15 Then
			If mx>=gui_mx+x Then
				If mx<=gui_mx+x+15 Then
					over=1
				EndIf
			EndIf
		EndIf
	EndIf
	If over=0 Then
		Color 0,0,0
	Else
		Color 100,255,100
	EndIf
	Rect gui_mx+x,gui_my+y,15,15,0
	If gui_checkb(id)=1 Then
		Rect gui_mx+x+2,gui_my+y+2,11,11,1
	EndIf
	Text gui_mx+x+18,gui_my+y-1,label$
	If over Then
		If mh Then
			mh=0
			md=0
			gui_checkb(id)=1-gui_checkb(id)
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return 0
	EndIf
End Function

;GUI Input
Function gui_inp(x,y,width,label$,id)
	Local over=0
	If my>=gui_my+y Then
		If my<=gui_my+y+35 Then
			If mx>=gui_mx+x Then
				If mx<=gui_mx+x+width Then
					over=1
					If mh Then
						FlushKeys()
						gui_selinput=id
						mh=0
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf
	If id=gui_selinput Then
		key=GetKey()
		If key>31 And StringWidth(gui_input$(id))<(width-8) Then gui_input$(id)=gui_input$(id)+Chr(key)
		If KeyHit(14) And Len(gui_input$(id))>0 Then gui_input$(id)=LSet(gui_input$(id), Len(gui_input$(id))-1)
		Color 100,255,100
	Else
		Color 0,0,0
	EndIf
	Rect gui_mx+x,gui_my+y+15,width,20,0
	Text gui_mx+x+2,gui_my+y+17,gui_input$(id)
	Color 0,0,0
	Text gui_mx+x,gui_my+y-2,label$
End Function

;Script starten
Function script_run(id)
	script=id
	script_timer2=0
	pause=0
	gamestop=1
	gui_on=0
	gui_messageon=0
	Select id
		Case 0
			gamestop=0
			FlushMouse()
			FlushKeys()
		Case 1
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 1
		Case 2
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 0
		Case 3
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 0
		Case 4
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 0
		Case 5
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 0
		Case 6
			EntityColor lspr, 0, 0, 0
			EntityAlpha lspr, 0
	End Select
End Function

;Cheaten
Function cheat(in$)
	Local cheat=1
	FlushKeys()
	Select in$
		Case "don't look behind ya"
			msg("Hmm sry, der geht (noch?) nicht!",1,2)
		Case "hey chiquitaaa!"
			msg("Hmm sry, der geht (noch?) nicht!",1,2)
		Case "snickers"
			pl_hunger=0
		Case "i want coke"
			pl_thirst=0
		Case "need bed from ikea"
			pl_tired=0
		Case "speaking turtles"
			pl_hi=5000
		Case "welcome to the sad world"
			pl_hi=0
		Case "bob the builder"
			For building.building = Each building
				If Int(EntityX(building\h1)/15)=pl_tilex Then
					If Int(EntityZ(building\h1)/15)=pl_tiley Then
						building\req_ast=0
						building\req_blatt=0
						building\req_stein=0
						building\req_liane=0
						building\req_baumstamm=0
						scantile()
					EndIf
				EndIf
			Next
		Case "i cant swim"
			msg("Hmm sry, der geht (noch?) nit!",1,2)
		Case "stoneage"
			item_take(9,50,"erhalten")
		Case "the garden of eden"
			For i=0 To 10
				grow()
			Next
		Case "hercules"
			pl_health=pl_health_max
			pl_power=100
		Case "i feel good"
			pl_health=pl_health_max
			pl_tired=0
			pl_hunger=0
			pl_thirst=0
			pl_hi=0
		Case "tooltime hrhrhr"
			tl_knife=1
			tl_ak=1
			tl_pistol=1
			tl_netz=1
			tl_speer=1
			tl_angel=1
			tl_axt=1
			tl_hammer=1
			tl_stnschl=1
		Case "fear my spear"
			tl_speer=1
		Case "unreal software rockz"
			pl_health_max=9999
			pl_health=pl_health_max
		Case "time 4 a big battle"				
			gm_infinitespear=1
			gm_infiniteammo=1
			tl_knife=1
			tl_ak=1
			tl_pistol=1
			tl_speer=1
			tl_stnschl=1
		Case "radioactive"
			For flora.flora=Each flora
				EntityColor flora\h, 0,255,0
				EntityBlend flora\h, 3
			Next
			For fauna.fauna=Each fauna
				EntityColor fauna\h, 0,255,0
				EntityBlend fauna\h, 3
			Next
			For building.building=Each building
				EntityColor building\h1, 0,255,0
				EntityBlend building\h1, 3
			Next
			For static.static=Each static
				EntityColor static\h, 0,255,0
				EntityBlend static\h, 3
			Next
			EntityColor terrain, 0,255,0
		Case "size-"
			For flora.flora=Each flora
				ScaleMesh flora\h, 0.5,0.5,0.5
			Next
		Case "size+"
			For flora.flora=Each flora
				ScaleMesh flora\h, 2,2,2
			Next
		Case "wth? giants!"
			For fauna.fauna=Each fauna
				ScaleEntity fauna\h, 2,2,2
			Next
		Case "supercheat"
			ExecFile "http://www.projectblitz.de"
		Default
			cheat=0
	End Select
	If cheat=1 Then msg("Cheat angewendet",1,1)
End Function

;Schlafen
Function sleep(mode=0)
	Select mode
		Case 0
			script_run(3)
		Case 1
			pl_health_cache=pl_health
			If gt_hour<18 And gt_hour>6 Then
				gt_hour=gt_hour+1
			Else
				If pl_tilebuild<>1 And pl_tilebuild<>2 Then
					hurt(Rand(10,30),0)
				ElseIf pl_tilebuildb<>0 Then
					hurt(Rand(10,30),0)
				EndIf
				If pl_tilebuild=1 Then
					hurt(Rand(0,10),0)
				EndIf
				If gt_hour>7 Then gt_day=gt_day+1
				gt_hour=6
				gt_min=Rand(1,59)
				grow()
			EndIf
			gametime()
	End Select
End Function

;Bewegen
Function move(diroff)
	Local px#, py#, pz#, yaw#
	Local mox#, moz#
	px#=EntityX(pivot)
	py#=EntityY(pivot)
	pz#=EntityZ(pivot)
	yaw#=EntityYaw(camera)
	mox#=Cos(yaw#+diroff)*pl_mspeed#
	moz#=Sin(yaw#+diroff)*pl_mspeed#
	TranslateEntity pivot, mox#, 0, moz#
	If pl_multimove=0 Then
		pl_walk=pl_walk+1
		pl_multimove=1
		down(1)
	EndIf
	If pl_walk>=10
		pl_walk=0
		If pl_jumpmode=0 Then
			If EntityY(pivot)<3.4 Then
				PlaySound sfx_swim
				effect_wave(px#,pz#,1)
			Else
				PlaySound sfx_step(Rand(0,1))
			EndIf
		EndIf
	EndIf
End Function

;Hurt
Function hurt(power, sound=1)
	If editor=0 Then pl_health=pl_health-power
	If sound=1 Then
		If lspr_alpha#<=0.4 Then
			PlaySound sfx_pain(Rand(0,2))
			EntityColor lspr, 255,0,0
			EntityAlpha lspr, 1
			lspr_fade#=-0.05
			lspr_alpha#=1
			For i=0 To power*2
			effect_splatter(camera_x#, camera_y#, camera_z#, Rnd(0.3,3), Rnd(-3,3),Rnd(1,3),Rnd(-3,3))
			Next
		EndIf
	EndIf
	If pl_health <= 0 Then
		pl_health = 0
		script_run(2)
	EndIf
End Function

;Down
Function down(steps=1)
	If gm_arcade>0 Then pl_down=0 : Return 0
	Local damage=0
	pl_down=pl_down+steps
	While pl_down>=100
		pl_down=pl_down-100
		If pl_tired<100 Then pl_tired=pl_tired+1
		If pl_hunger<100 Then pl_hunger=pl_hunger+1
		If pl_thirst<100 Then pl_thirst=pl_thirst+1
		If pl_tired=100 Then damage=damage+1
		If pl_hunger=100 Then damage=damage+1
		If pl_thirst=100 Then damage=damage+1
		If damage>0 Then hurt(damage)
	Wend
End Function

;Attackanimal
Function attackanimal(h, power)
	Local x#,y#,z#, healthc
	If h=0 Then Return 0
	If GetEntityType(h)<>ct_fauna Then Return 0
	For fauna.fauna = Each fauna
		If fauna\h=h Then
			PlaySound sfx_hitflesh
			healthc=fauna\health
			fauna\health = fauna\health - power
			If healthc>0 And fauna\health<0 Then 
				gm_killed(fauna\typ)=gm_killed(fauna\typ)+1
				Select fauna\typ
					Case 1
						msg("Schildkrte gettet (+5 Energie XP)",1,1)
						healthxp(5)
					Case 2
						msg("Krebs gettet (+2 Energie XP)",1,1)
						healthxp(2)
					Case 5
						msg("Lwen gettet (+10 Energie XP)",1,1)
						healthxp(10)
					Case 6
						msg("Kiffer Opa gettet (+30 Energie XP)",1,1)
						healthxp(30)
					Case 8
						msg("Kiwi gettet (+1 Energie XP)",1,1)
						healthxp(1)
					Case 9
						msg("Raptor gettet (+20 Energie XP)",1,1)
						healthxp(20)
					Case 10
						msg("Soldat gettet (+30 Energie XP)",1,1)
						healthxp(30)
					Case 11
						msg("Eingeborenen gettet (+30 Energie XP)",1,1)
						healthxp(30)
					Case 12
						msg("Vogel gettet (+5 Energie XP)",1,1)
						healthxp(5)
				End Select
			EndIf
			x#=EntityX(fauna\h)
			y#=EntityY(fauna\h)
			z#=EntityZ(fauna\h)
			For i=0 To power*1.5
				effect_splatter(x#, y#, z#, Rnd(0.3,2), Rnd(-3,3),Rnd(1,3),Rnd(-3,3))
			Next
			Return 1
		EndIf
	Next
	Return 0
End Function

;Grid
Function grid()
	Local cube, x, z
	If grid=0 Then
		grid=1
		grid_master=CreatePivot()
		For x=0 To msz
			cube=CreateCube()
			PositionEntity cube, (x*15)+7.5, 30, 0
			ScaleEntity cube, 0.2,0.2,2000
			EntityColor cube, 100,255,100
			EntityAlpha cube, 0.3
			EntityFX cube, 1
			EntityParent cube, grid_master
			grid_x(x)=cube
		Next
		For z=0 To msz
			cube=CreateCube()
			PositionEntity cube, 0, 30, (z*15)+7.5
			ScaleEntity cube, 2000,0.2,0.2
			EntityColor cube, 100,255,100
			EntityAlpha cube, 0.3
			EntityFX cube, 1
			EntityParent cube, grid_master
			grid_z(z)=cube
		Next
	Else
		grid=0
		FreeEntity grid_master
	EndIf
End Function

;Message
Function msg(msg$, sound=1, col=0)
	If sound Then
		If col=2 Then
			PlaySound sfx_error
		Else
			PlaySound sfx_action
		EndIf
	EndIf
	For i = 0 To 5
		If gui_msg$(i)="" Then
			gui_msg$(i)=msg$
			gui_msgt(i)=0
			gui_msgc(i)=col
			Exit
		EndIf
	Next
End Function

;Weather
Function weather()
End Function

;Update Light
Function updatelight(light)
	Local lsky
	If light<100 Then
		lsky=light+(light-100)
	Else
		lsky=light
	EndIf
	lsky=lsky+105
	AmbientLight light*.7,light*.7,light*.7
	EntityColor sky, lsky,lsky,lsky
	CameraFogColor camera, light*.8,light*.85+30,light*.9+50
End Function

;A - Search
Function a_search(find=0)
	Local fo, foc
	If find=0 Then
		If gui_on=1 Then gui_on=0
		If pl_actiontotal>0 Then Return 0
		pl_actionakt=0
		pl_actiontotal=100
		pl_action="suchen"
		down(500)
	Else
		fo=-1
		If Rand(2)=1 Then fo=15
		If Rand(10)=1 Then fo=11
		Select pl_tileflora
			;Bume
			Case 1,2,4
				If Rand(3)=1 Then fo=4 Else fo=1
				If Rand(6)=1 Then fo=2
				If Rand(3)<>1 Then
					If item_use(4, "", 1, 4) Then fo=4
				EndIf
			;Bananenbaum
			Case 3
				If Rand(2)=1 Then fo=10
			;Lianenbaum
			Case 5
				If Rand(5)=1 Then fo=2 Else fo=4
			;Trockener Baum
			Case 6
				If Rand(5)<>1 Then fo=1
			;Bsche
			Case 40,41,42,43
				If Rand(5)=1 Then fo=1 Else fo=2
			;Steine
			Case 50,51,52
				If Rand(4)=1 Then fo=9 Else fo=3
		End Select
		;Nichts finden
		If Rand(13)=1 Then fo=-1
		;Ausgabe / Objekt geben
		If fo=-1 Then
			msg("Ich konnte leider nichts finden!")
		Else
			Select fo
				Case 1 foc=Rand(1,3)
				Case 2 foc=Rand(1,3)
				Case 3 foc=Rand(1,3)
				Case 4 foc=Rand(1,2)
				Case 9 foc=Rand(5,12)
				Default foc=1
			End Select
			item_take(fo,foc,"gefunden","Objekt(e) gefunden, aber kein freier Platz!")
		EndIf
	EndIf
End Function

;A - Climb
Function a_climb(down=0, start=0)
	If start=1 Then
		If gui_on=1 Then gui_on=0
		If pl_actiontotal>0 Then Return 0
		pl_actionakt=0
		pl_actiontotal=60
		If down=0 Then pl_action="hochklettern" Else pl_action="runterklettern"
		down(100)
		pl_jumpmode=-100
	Else
		EntityType pivot,0
		If down=0 Then
			If EntityY(pivot)<TerrainY(terrain,EntityX(pivot),0,EntityZ(pivot))+37 And pl_jumpmode<>0 Then
				TranslateEntity pivot, 0,0.4,0
			Else
				pl_jumpmode=0
				pl_fallspeed#=0.5
				EntityType pivot,ct_player
				EntityType cpivot,ct_player
			EndIf
		Else
			If EntityY(pivot)>TerrainY(terrain,EntityX(pivot),0,EntityZ(pivot))+7 And pl_jumpmode<>0 Then
				TranslateEntity pivot, 0,-0.4,0
			Else
				pl_jumpmode=0
				pl_fallspeed#=0.5
				EntityType pivot,ct_player
				EntityType cpivot,ct_player
			EndIf
		EndIf
		If pl_actionakt=pl_actiontotal Then
			pl_jumpmode=0
			EntityType pivot,ct_player
			EntityType cpivot,ct_player
		EndIf
	EndIf
End Function

;A-Drive
Function a_drive(drive)
	If drive=0 Then
		If EntityX(pivot)>0 And EntityX(pivot)<(15*85) And EntityZ(pivot)>0 And EntityZ(pivot)<(15*85) Then
			EntityType pl_driveh, ct_flora
			pl_drive=0
			pl_driveh=0
			pl_driveacc#=0
			pl_jumpmode=0
			msg("Du bist abgestiegen",1,1)
			EntityType pivot, ct_player
			EntityType cpivot,ct_player
			Return 1
		Else
			msg("Das Wasser ist hier zu tief zum absteigen!",1,2)
			Return 0
		EndIf
	Else
		For building.building = Each building
			If Int(EntityX(building\h1)/15)=pl_tilex Then
				If Int(EntityZ(building\h1)/15)=pl_tiley Then
					pl_drive=1
					pl_driveh=building\h1
					pl_driveacc#=0
					pl_jumpmode=-100
					If gui_on=1 Then gui_on=0
					msg("Du fhrst nun Flo",1,1)
					PositionEntity pivot, EntityX(pl_driveh),EntityY(pl_driveh)+11,EntityZ(pl_driveh)
					EntityType pivot, 0
					EntityType cpivot, 0
					EntityType pl_driveh, 0
					Return 1
				EndIf
			EndIf
		Next
		Return 0
	EndIf
End Function

Function a_angeln(angel=0)
	If angel=0 Then
		If gui_on=1 Then gui_on=0
		If pl_actiontotal>0 Then Return 0
		pl_actionakt=0
		pl_actiontotal=150
		pl_action="angeln"
		PlaySound sfx_fishing
	Else
		If item_use(15,"als Kder verwendet") Then
			item_take(16,1,"geangelt")
		Else
			If Rand(4)=1 Then
				item_take(16,1,"geangelt")
			Else
				msg("Es hat nichts angebissen!",1,2)
			EndIf
		EndIf
	EndIf
End Function

;Tool
Function settool(id)
	Local ctool=pl_tool
	If id=1 And tl_knife=0 Then Return 0
	If id=2 And tl_ak=0 Then Return 0
	If id=3 And tl_pistol=0 Then Return 0
	If id=4 And tl_netz=0 Then Return 0
	If id=5 And tl_speer=0 Then Return 0
	If id=6 And tl_angel=0 Then Return 0
	If id=7 And tl_axt=0 Then Return 0
	If id=8 And tl_hammer=0 Then Return 0
	If id=9 And tl_stnschl=0 Then Return 0
	If id<0 Then Return 0
	If id>9 Then Return 0
	pl_tool=id
	pl_toolmsg$=""
	Select id
		;Hand
		Case 0
			If pl_tilebuild=7 And pl_tilebuildb=0 Then
				pl_toolmsg$="Fische aus Reuse nehmen"
			ElseIf TerrainY(terrain, camera_x#, camera_y#, camera_z#)<1.4 Then
				pl_toolmsg$="Salzwasser trinken"
			ElseIf pl_tileflora=52 Then
				pl_toolmsg$="Swasser trinken"
			ElseIf pl_tileflora=20 Then
				pl_toolmsg$="Getreide ernten"
			ElseIf pl_tileflora=21 Then
				pl_toolmsg$="Hanf ernten"
			ElseIf pl_tileflora=31 Then
				pl_toolmsg$="Beeren pflcken"
			ElseIf pl_tileflora=33 Then
				pl_toolmsg$="Gummibeeren pflcken"
			ElseIf pl_tilebuild=6 And pl_tilebuildb=0 Then
				pl_toolmsg$="Nahrung aus Lager essen"
			ElseIf pl_tilebuild=25 Then
				pl_toolmsg$="Munition nehmen"
			ElseIf pl_tilebuild=26 And tl_pistol=0 Then
				pl_toolmsg$="Pistole nehmen"
			ElseIf pl_tilebuild=27 And tl_ak=0 Then
				pl_toolmsg$="AK nehmen"
			EndIf
		;Messer
		Case 1
			pl_toolmsg$=""
		;AK
		Case 2
			If ctool<>id Then PlaySound sfx_ak_take
			pl_toolmsg$=""
		;Pistole
		Case 3
			If ctool<>id Then PlaySound sfx_pistol_take
			pl_toolmsg$=""
		;Netz
		Case 4
			pl_toolmsg$=""
		;Speer
		Case 5
			pl_toolmsg$=""
		;Angel
		Case 6
			If TerrainY(terrain, camera_x#, 0, camera_z#)<1.5 Then
				pl_toolmsg$="angeln"
			EndIf
		;Axt
		Case 7
			If pl_tileflora>0 And pl_tileflora<=9 Then
				pl_toolmsg$="Baum fllen"
			ElseIf pl_tileflora>29 And pl_tileflora<50 Then
				pl_toolmsg$="Busch fllen"
			EndIf
		;Hammer
		Case 8
			If pl_tilex>=0 And pl_tiley>=0 And pl_tilex<=msz And pl_tiley<=msz Then
				If pl_tilebuild<>0 And pl_tilebuildb>0 Then
					pl_toolmsg$="bauen ("+(100-pl_tilebuildr)+"%)"
				ElseIf mapfree(pl_tilex,pl_tiley)=0 Then
					pl_toolmsg$="bauen"
				ElseIf pl_tileflora=2 And pl_tilebuild=0 Then
					pl_toolmsg$="bauen"
				ElseIf pl_tileflora>49 And pl_tileflora<60 Then
					pl_toolmsg$="Stein zerschlagen"
				EndIf
			EndIf
		;Steinschleuder
		Case 9
			pl_toolmsg$=""
	End Select
	Return 1
End Function

;Buildplace
Function buildplace(typ)
	Local ok
	If multidown>0 Then Return 0
	multidown=5
	If pl_tilex<0 Or pl_tiley<0 Or pl_tilex>msz Or pl_tiley>msz Then
		msg("Hier kannst du nichts bauen!",1,2)
		Return 0
	EndIf
	If typ<>2 And mapfree(pl_tilex, pl_tiley)=1 Then
		msg("Hier kannst du nichts bauen!",1,2)
		Return 0
	EndIf
	If typ=2 And pl_tileflora<>2 Then
		msg("Dafr brauchst du einen hohen Baum!",1,2)
		Return 0		
	EndIf
	If typ=5 Then
		ok=0
		For building.building = Each building
			If building\typ=3 Then
				ok=1
				Exit
			EndIf
		Next
		If ok=0 Then
			msg("Dafr brauchst du eine Feuerstelle!",1,2)
			Return 0
		EndIf
	EndIf
	If typ=4 Then
		If TerrainY(terrain, camera_x#, 0, camera_z#)>0.2 Then
			msg("Das Flo muss im Wasser gebaut werden!",1,2)
			Return 0			
		EndIf
	ElseIf typ=7 Then
		If TerrainY(terrain, camera_x#, 0, camera_z#)>1 Then
			msg("Die Reuse muss im Wasser gebaut werden!",1,2)
			Return 0
		EndIf
	Else
		If TerrainY(terrain, camera_x#, 0, camera_z#)<1.6 Then
			msg("Das kannst du nicht im Wasser bauen!",1,2)
			Return 0
		EndIf
	EndIf
	building.building = New building
	ha = CopyMesh(m_building)
	EntityFX ha,16
	ScaleEntity ha,0.15,0.15,0.15
	building\h1 = ha
	building\h2 = CreatePivot()
	building\h3 = CreatePivot()
	building\typ = typ
	PositionEntity ha, pl_tilex*15, TerrainY(terrain,pl_tilex*15,0,pl_tiley*15)+3,pl_tiley*15
	EntityAutoFade ha, opt_autofade_s, opt_autofade_e
	mapfree(pl_tilex, pl_tiley)=1
	down(500)
	pl_tooltotal=30
	pl_toolakt=pl_tooltotal
	Select typ
		Case 1 msg("Baustelle fr Htte angelegt",1,1)
			building\req_ast=5
			building\req_blatt=5
			building\req_stein=4
			building\req_liane=3
			building\req_baumstamm=0
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm
		Case 2 msg("Baustelle fr Baumhaus angelegt",1,1)
			building\req_ast=10
			building\req_blatt=5
			building\req_stein=0
			building\req_liane=5
			building\req_baumstamm=5
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm
		Case 3 msg("Baustelle fr Feuerstelle angelegt",1,1)
			building\req_ast=10
			building\req_blatt=0
			building\req_stein=5
			building\req_liane=0
			building\req_baumstamm=0
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm
		Case 4 msg("Baustelle fr Flo angelegt",1,1)
			building\req_ast=5
			building\req_blatt=10
			building\req_stein=0
			building\req_liane=5
			building\req_baumstamm=15
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm
		Case 5 msg("Baustelle fr Fackel angelegt",1,1)
			building\req_ast=3
			building\req_blatt=0
			building\req_stein=0
			building\req_liane=0
			building\req_baumstamm=0
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm	
		Case 6 msg("Baustelle fr Lager angelegt",1,1)
			building\req_ast=5
			building\req_blatt=0
			building\req_stein=10
			building\req_liane=0
			building\req_baumstamm=5
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm	
		Case 7 msg("Baustelle fr Reuse angelegt",1,1)
			building\req_ast=5
			building\req_blatt=0
			building\req_stein=0
			building\req_liane=10
			building\req_baumstamm=0
			building\req_total=building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm	
	End Select
	scantile()
End Function

;Schieen
Function shoot(power, range=0)
	Local x#,y#,z#,dx,dy,dz,h=0, hitfauna=0
	h=CameraPick(camera, opt_sx/2, opt_sy/2)
	x#=PickedX()
	y#=PickedY()
	z#=PickedZ()
	If h<>0 Then
		For fauna.fauna = Each fauna
			If fauna\h=h Then
				If range>0 Then
					If x#>camera_x# Then dx=x#-camera_x# Else dx=camera_x#-x#
					If y#>camera_y# Then dy=y#-camera_y# Else dy=camera_y#-y#
					If z#>camera_z# Then dz=z#-camera_z# Else dz=camera_z#-z#
					If dx<range And dy<range And dz<range Then
						attackanimal(h, power)
						Exit
					Else
						Exit
					EndIf
				Else
					hitfauna=1
					attackanimal(h, power)
					Exit
				EndIf
			EndIf
		Next
	EndIf
	If range=0 Then
		If hitfauna=0 Then
			If y#<1.3 Then
				effect_splash(x#,z#,Rnd(0.2,1),Rnd(0.1,0.8))
			Else
				If Rand(6)=1 Then
					effect_puff(x#,y#,z#,Rnd(0.05,0.1),150,150,150,Rnd(0.7,0.9), Rnd(0.02,0.03))
				Else
					effect_splatter(x#,y#,z#, Rnd(0.3,2), Rnd(-1,1),Rnd(1,2),Rnd(-1,1), 80,80,80)
				EndIf
			EndIf
		EndIf
	EndIf
End Function

;Attack
Function attack()
	If pl_toolakt>0 Then Return 0
	Local x#,y#,z#,ok,yaw#
	Select pl_tool
		Case 0																		;0 Hand
			If pl_tilebuild=6 And mh=1 And pl_tilebuildb=0 Then
				For building.building = Each building
					If Int(EntityX(building\h1)/15)=pl_tilex Then
						If Int(EntityZ(building\h1)/15)=pl_tiley Then
							If building\typ=6 Then
								If building\mode=0 Then
									msg("Das Lager ist leer!",1,2)
									Return 0
								EndIf
								While pl_hunger>0 And building\mode>0
									building\mode=building\mode-1
									pl_hunger=pl_hunger-1
									pl_health=pl_health+1
								Wend
								If building\mode>0 Then
									msg("Nahrung aus Lager gegessen",1,1)
								Else
									msg("Nahrung aus Lager gegessen, Lager ist nun Leer!",1,2)
								EndIf
								pl_tooltotal=50
								pl_toolakt=pl_tooltotal
								Return 1
							EndIf
						EndIf
					EndIf
				Next
			ElseIf pl_tilebuild=7 And pl_tilebuildb=0 Then
				For building.building = Each building
					If Int(EntityX(building\h1)/15)=pl_tilex Then
						If Int(EntityZ(building\h1)/15)=pl_tiley Then
							If building\mode>0 Then
								If item_take(16,building\mode, "aus Reuse genommen")
									building\mode=0
									pl_tooltotal=50
									pl_toolakt=pl_tooltotal
									Return 1
								EndIf
							Else
								msg("Die Reuse ist leer!",1,2)
								pl_tooltotal=50
								pl_toolakt=pl_tooltotal
								Return 0
							EndIf
						EndIf
					EndIf
				Next			
			ElseIf pl_tileflora=0 And mh=1 Then
				If TerrainY(terrain, camera_x#, camera_y#, camera_z#)<1.4 Then
					pl_tooltotal=30
					pl_toolakt=pl_tooltotal
					PlaySound sfx_drink
					pl_thirst=pl_thirst+5
					msg("Salzwasser getrunken (+5 Durst)",0,1)
				EndIf
			ElseIf pl_tileflora=52 Then
				pl_tooltotal=50
				pl_toolakt=pl_tooltotal
				PlaySound sfx_drink
				pl_thirst=pl_thirst-20
				msg("Swasser getrunken (-20 Durst)",0,1)
			ElseIf pl_tileflora=31 Then
				If item_take(5,5, "geerntet") Then
					pl_tooltotal=50
					pl_toolakt=pl_tooltotal
					For flora.flora = Each flora
						If Int(EntityX(flora\h)/15)=pl_tilex Then
							If Int(EntityZ(flora\h)/15)=pl_tiley Then
								yaw#=EntityYaw(flora\h)
								x#=EntityX(flora\h)
								y#=EntityY(flora\h)
								z#=EntityZ(flora\h)
								For i=0 To 50
									effect_splatter((pl_tilex*15),camera_y#+5,(pl_tiley*15),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,20,20,1)
								Next
								FreeEntity flora\h
								Delete flora
							EndIf
						EndIf
					Next
					terrain_flora_add(x#,y#,z#, 30, 0, yaw#)
					scantile()
				EndIf
			ElseIf pl_tileflora=33 Then
				If item_take(26,5, "geerntet") Then
					pl_tooltotal=50
					pl_toolakt=pl_tooltotal
					For flora.flora = Each flora
						If Int(EntityX(flora\h)/15)=pl_tilex Then
							If Int(EntityZ(flora\h)/15)=pl_tiley Then
								yaw#=EntityYaw(flora\h)
								x#=EntityX(flora\h)
								y#=EntityY(flora\h)
								z#=EntityZ(flora\h)
								For i=0 To 50
									effect_splatter((pl_tilex*15),camera_y#+5,(pl_tiley*15),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,20,20,1)
								Next
								FreeEntity flora\h
								Delete flora
							EndIf
						EndIf
					Next
					terrain_flora_add(x#,y#,z#, 32, 0, yaw#)
					scantile()
				EndIf
			ElseIf pl_tileflora=20 Then
				ok=0
				If item_take(8,obj_value(), "geerntet") Then
					pl_tooltotal=30
					pl_toolakt=pl_tooltotal
					For flora.flora = Each flora
						If Int(EntityX(flora\h)/15)=pl_tilex Then
							If Int(EntityZ(flora\h)/15)=pl_tiley Then
								FreeEntity flora\h
								Delete flora
								For i=0 To 50
									effect_splatter((pl_tilex*15),camera_y#+5,(pl_tiley*15),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,20,20,1)
								Next
							EndIf
						EndIf
					Next
					mapfree(pl_tilex, pl_tiley)=0
					scantile()
				EndIf
			ElseIf pl_tileflora=21 Then
				If item_take(17,obj_value(), "geerntet") Then
					pl_tooltotal=30
					pl_toolakt=pl_tooltotal	
					For flora.flora = Each flora
						If Int(EntityX(flora\h)/15)=pl_tilex Then
							If Int(EntityZ(flora\h)/15)=pl_tiley Then
								FreeEntity flora\h
								Delete flora
								For i=0 To 50
									effect_splatter((pl_tilex*15),camera_y#+5,(pl_tiley*15),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,20,20,1)
								Next
							EndIf
						EndIf
					Next
					mapfree(pl_tilex, pl_tiley)=0
					scantile()
				EndIf
			ElseIf pl_tilebuild=25 Then
				If item_take(28,30, "genommen") Then
					pl_tooltotal=30
					pl_toolakt=pl_tooltotal
				EndIf
			ElseIf pl_tilebuild=26 And tl_pistol=0 Then
				tl_pistol=1
				msg("Pistole genommen",0,3)
				PlaySound sfx_skill	
				pl_tooltotal=30
				pl_toolakt=pl_tooltotal
			ElseIf pl_tilebuild=27 And tl_ak=0 Then
				tl_ak=1
				msg("AK genommen",0,3)
				PlaySound sfx_skill
				pl_tooltotal=30
				pl_toolakt=pl_tooltotal
			EndIf
		
		
		
		
		Case 1																		;1 Messer
			PlaySound sfx_knife
			pl_tooltotal=10
			pl_toolakt=pl_tooltotal
			shoot(pl_power+5,15)
		
		Case 2																		;2 AK
			If item_use(28, "") Or gm_infiniteammo=1 Then
				PlaySound sfx_ak
				ShowEntity mflash : mflasht=2
				pl_tooltotal=3
				pl_toolakt=pl_tooltotal
				effect_ammo(camera_x#,camera_y#+2,camera_z#,Rand(-2,2),Rand(0,3),Rand(-2,2))
				shoot(11)
			ElseIf mh=1
				msg("Du hast keine Munition!",1,2)
			EndIf
		
		Case 3																		;3 Pistole
			If item_use(28, "") Or gm_infiniteammo=1 Then
				PlaySound sfx_pistol
				ShowEntity mflash : mflasht=2
				pl_tooltotal=10
				pl_toolakt=pl_tooltotal
				effect_ammo(camera_x#,camera_y#+2,camera_z#,Rand(-2,2),Rand(0,3),Rand(-2,2))
				shoot(15)
			ElseIf mh=1
				msg("Du hast keine Munition!",1,2)
			EndIf
		
		Case 4																		;4 Netz
			PlaySound sfx_netwosh
			pl_tooltotal=15
			pl_toolakt=pl_tooltotal
			h=CameraPick(camera, opt_sx/2, opt_sy/2)
			x#=PickedX()
			y#=PickedY()
			z#=PickedZ()
			If h<>0 Then
				For fauna.fauna = Each fauna
					If fauna\h=h Then
						If fauna\typ=4 Then
							If x#>camera_x# Then dx=x#-camera_x# Else dx=camera_x#-x#
							If y#>camera_y# Then dy=y#-camera_y# Else dy=camera_y#-y#
							If z#>camera_z# Then dz=z#-camera_z# Else dz=camera_z#-z#
							If dx<15 And dy<15 And dz<15 Then
								If item_take(29,1, "genommen") Then
									FreeEntity fauna\h
									Delete fauna
								EndIf
							EndIf
						EndIf
						Exit
					EndIf
				Next
			EndIf

			
		
		Case 5																		;5 Speer
			If mh Then
				PlaySound sfx_wosh
				pl_tooltotal=30
				pl_toolakt=pl_tooltotal																		
				effect_spear()
				If gm_infinitespear=0 Then
					tl_speer=0
					settool(0)
				EndIf
			EndIf

		
		Case 6																		;6 Angel
			If TerrainY(terrain, camera_x#, 0, camera_z#)<1.5 Then
				a_angeln(0)
				pl_tooltotal=150
				pl_toolakt=pl_tooltotal
			Else
				msg("Hier kannst du nicht angeln!",1,2)
				pl_tooltotal=30
				pl_toolakt=pl_tooltotal
			EndIf
		
		Case 7																		;7 Axt
			If pl_tileflora>0 And pl_tileflora<=9 Then
				For e_flora.flora = Each flora
					If Int(EntityX(e_flora\h)/15)=pl_tilex Then
						If Int(EntityZ(e_flora\h)/15)=pl_tiley Then
							If e_flora\health>0 Then
								down(50)
								pl_tooltotal=30
								pl_toolakt=pl_tooltotal
								PlaySound sfx_woodcut(Rand(0,1))
								For i=0 To 50
									effect_fragment(camera_x#, camera_y#+5.5,camera_z#, Rnd(0.5,3), Rnd(-2,2),Rnd(0,0.8),Rnd(-2,2), Rand(140,180), 80, 10)
								Next
								e_flora\health=e_flora\health-(pl_power/2)
								If e_flora\health<=0 Then
									For i=0 To 100
										effect_splatter(camera_x#,camera_y#+5,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,5),Rnd(-2,2),255,20,20,1)
									Next
									msg("Baum gefllt (+5 Kraft XP)", 0,1)
									attackxp(5)
									For building.building = Each building
										If Int(EntityX(building\h1)/15)=pl_tilex Then
											If Int(EntityZ(building\h1)/15)=pl_tiley Then
												FreeEntity building\h1
												Delete building
												msg("Baumhaus abgerissen!", 0,2)
											EndIf
										EndIf
									Next
									PlaySound sfx_treefall
								EndIf
								Exit
							EndIf
						EndIf
					EndIf
				Next
			ElseIf pl_tileflora>29 And pl_tileflora<50 Then
				For e_flora.flora = Each flora
					If Int(EntityX(e_flora\h)/15)=pl_tilex Then
						If Int(EntityZ(e_flora\h)/15)=pl_tiley Then
							If e_flora\health>0 Then
								down(50)
								pl_tooltotal=30
								pl_toolakt=pl_tooltotal
								PlaySound sfx_woodcut(Rand(0,1))
								For i=0 To 50
									effect_fragment(camera_x#, camera_y#+5.5,camera_z#, Rnd(0.5,3), Rnd(-2,2),Rnd(0,0.8),Rnd(-2,2), Rand(140,180), 80, 10)
								Next
								e_flora\health=e_flora\health-(pl_power/2)
								If e_flora\health<=0 Then
									For i=0 To 100
										effect_splatter(camera_x#,camera_y#+5,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,5),Rnd(-2,2),255,20,20,1)
									Next
									msg("Busch gefllt (+3 Kraft XP)", 0,1)
									attackxp(3)
								EndIf
							EndIf
						EndIf
					EndIf
				Next
			EndIf
			
		Case 8																		;8 Hammer
			If pl_tileflora>49 And pl_tileflora<60 Then
				For e_flora.flora = Each flora
					If Int(EntityX(e_flora\h)/15)=pl_tilex Then
						If Int(EntityZ(e_flora\h)/15)=pl_tiley Then
							If e_flora\health>0 Then
								down(50)
								pl_tooltotal=30
								pl_toolakt=pl_tooltotal
								PlaySound sfx_hack
								e_flora\health=e_flora\health-(pl_power/2)
								If e_flora\health<=0 Then
									msg("Stein zerschlagen (+5 Kraft XP)", 1,1)
									attackxp(5)
								EndIf
							EndIf
						EndIf
					EndIf
				Next
			ElseIf pl_tilex>=0 And pl_tiley>=0 And pl_tilex<=msz And pl_tiley<=msz Then
				If pl_tilebuild=0 Then
					If mh Then
						message_set(100)
					EndIf
				ElseIf pl_tilebuildr>-1 Then
					For building.building = Each building
						If Int(EntityX(building\h1)/15)=pl_tilex Then
							If Int(EntityZ(building\h1)/15)=pl_tiley Then
								If building\buildstep=0 Then
									ok=0
									If ok=0 And building\req_ast>0 Then
										If item_use(1, "verbaut") Then ok=1 : building\req_ast=building\req_ast-1
									EndIf
									If ok=0 And building\req_blatt>0 Then
										If item_use(2, "verbaut") Then ok=1 : building\req_blatt=building\req_blatt-1
									EndIf
									If ok=0 And building\req_stein>0 Then
										If item_use(3, "verbaut") Then ok=1 : building\req_stein=building\req_stein-1
									EndIf
									If ok=0 And building\req_liane>0 Then
										If item_use(4, "verbaut") Then ok=1 : building\req_liane=building\req_liane-1
									EndIf
									If ok=0 And building\req_baumstamm>0 Then
										If item_use(7, "verbaut") Then ok=1 : building\req_baumstamm=building\req_baumstamm-1
									EndIf
									scantile()
									If building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm=0 Then
										ok=1
									EndIf
									If ok=0 Then
										msg("Du hast keines der bentigten Items:",1,2)
										msg(building\req_ast+" ste, "+building\req_blatt+" Bltter,"+building\req_stein+" Steine,"+building\req_liane+" Lianen,"+building\req_baumstamm+" Baumst.",1,2)
										pl_tooltotal=30
										pl_toolakt=pl_tooltotal
									Else
										building\buildstep=1
										pl_tooltotal=30
										pl_toolakt=pl_tooltotal
									EndIf
								Else
									building\buildstep=building\buildstep+1
									If building\buildstep>=6 Then
										building\buildstep=0
										If (100-pl_tilebuildr)=100 Then 
											x#=EntityX(building\h1)
											y#=EntityY(building\h1)
											z#=EntityZ(building\h1)
											FreeEntity building\h1
											For i=0 To 50
												effect_splatter(x#,y#+5,z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),80,255,80,1)
											Next
											If building\typ<>2 Then
												For flora.flora = Each flora
													If Int(EntityX(flora\h)/15)=pl_tilex Then
														If Int(EntityZ(flora\h)/15)=pl_tiley Then
															FreeEntity flora\h
															Delete flora
														EndIf
													EndIf
												Next
											EndIf
											typ=building\typ
											Delete building
											terrain_building_add(x#,y#,z#, typ, 1)
											scantile()
										EndIf
									EndIf
									down(50)
									pl_tooltotal=30
									pl_toolakt=pl_tooltotal
									PlaySound sfx_build
									For i=0 To 5
										effect_puff(camera_x#+Rnd(-1,1),camera_y#+3,camera_z#+Rnd(-1,1),Rnd(0.2,0.6),200,150,150,Rnd(0.1,0.5))
									Next	
								EndIf
								Return 0
							EndIf
						EndIf
					Next
				EndIf
			EndIf
			
			
		Case 9																		;9 Steinschleuder
			If item_use(9, "") Then
				PlaySound sfx_schleuder
				pl_tooltotal=20
				pl_toolakt=pl_tooltotal																		
				effect_stone()
			Else
				msg("Du brauchst Steinchen zum Schiessen!",1,2)
				pl_tooltotal=30
				pl_toolakt=pl_tooltotal
			EndIf
	End Select
End Function

;Attack XP
Function attackxp(value)
	pl_power_up=pl_power_up+value
	If pl_power_up>=pl_skillup Then
		msg("Deine Kraft hat sich erhht", 0,3)
		PlaySound sfx_skill
		For i=0 To 100
			effect_splatter(camera_x#,camera_y#+5,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,5),Rnd(-2,2),255,255,0,1)
		Next
		pl_power_up=pl_power_up-pl_skillup
		pl_power=pl_power+pl_skillupp
	EndIf
End Function

;Health XP
Function healthxp(value)
	pl_health_up=pl_health_up+value
	If pl_health_up>=pl_skillup Then
		msg("Deine Energie hat sich erhht", 0,3)
		PlaySound sfx_skill
		For i=0 To 100
			effect_splatter(camera_x#,camera_y#+5,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,5),Rnd(-2,2),255,255,0,1)
		Next
		pl_health_up=pl_health_up-pl_skillup
		pl_health=pl_health+pl_skillupp
		pl_health_max=pl_health_max+pl_skillupp
	EndIf
End Function

;Scantile
Function scantile()
	pl_tilebuild=0
	pl_tilebuildr=0
	pl_tileflora=0
	pl_tilefauna=0
	pl_tilex=Int(EntityX(pivot)/15)
	pl_tiley=Int(EntityZ(pivot)/15)
	;Pflanzen
	For e_flora.flora = Each flora
		If Int(EntityX(e_flora\h)/15)=pl_tilex Then
			If Int(EntityZ(e_flora\h)/15)=pl_tiley Then
				pl_tileflora=e_flora\typ
			EndIf
		EndIf
	Next
	;Tiere
	For e_fauna.fauna = Each fauna
		If Int(EntityX(e_fauna\h)/15)=pl_tilex Then
			If Int(EntityZ(e_fauna\h)/15)=pl_tiley Then
				pl_tilefauna=e_fauna\typ
			EndIf
		EndIf
	Next
	;Gebude
	For building.building = Each building
		If Int(EntityX(building\h1)/15)=pl_tilex Then
			If Int(EntityZ(building\h1)/15)=pl_tiley Then
				pl_tilebuild=building\typ
				pl_tilebuildr=((Float(building\req_ast+building\req_blatt+building\req_stein+building\req_liane+building\req_baumstamm))/Float(building\req_total))*Float(100)
				pl_tilebuildb=building\req_total
				Select pl_tilebuild
					;Checkpoint
					Case 10
						If building\mode<>10 Then
							building\mode=10
							PlaySound sfx_checkp
							msg("Checkpoint aktiviert!",1,1)
							gm_checkp=gm_checkp+1
							x#=EntityX(building\h1)
							y#=EntityY(building\h1)+12
							z#=EntityZ(building\h1)
							For i=0 To 50
								effect_splatter(x#,y#,z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,255,0,1)
							Next
						EndIf
					;Stacheln
					Case 30
						If EntityY(building\h1)>camera_y Then dy=EntityY(building\h1)-camera_y Else dy=camera_y-EntityY(building\h1)
						If dy<4 Then
							pl_health=0
							hurt(5)
						EndIf
				End Select
			EndIf
		EndIf
	Next
	;Items
	For item.item = Each item
		If Int(EntityX(item\h)/15)=pl_tilex Then
			If Int(EntityZ(item\h)/15)=pl_tiley Then
				If item\typ<200 Then
					If item_take(item\typ)=1 Then
						For i=0 To 50
							effect_splatter(EntityX(item\h),EntityY(item\h),EntityZ(item\h),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),80,255,80,1)
						Next
						item_free(EntityX(item\h),EntityZ(item\h))
					EndIf
				Else
					Select item\typ
						Case 200 tl_stnschl=1 : msg("Steinschleuder gefunden!",0,3)
						Case 201 tl_hammer=1 : msg("Hammer gefunden!",0,3)
						Case 202 tl_axt=1 : msg("Axt gefunden!",0,3)
						Case 203 tl_angel=1 : msg("Angel gefunden!",0,3)
						Case 204 tl_speer=1 : msg("Speer gefunden!",0,3)
						Case 205 tl_netz=1 : msg("Netz gefunden!",0,3)
						Case 206 tl_pistol=1 : msg("Pistole gefunden!",0,3)
						Case 207 tl_ak=1 : msg("AK gefunden!",0,3)
						Case 208 tl_knife=1 : msg("Messer gefunden!",0,3)
					End Select
					PlaySound sfx_skill
					For i=0 To 50
						effect_splatter(EntityX(item\h),EntityY(item\h),EntityZ(item\h),Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,255,0,1)
					Next
					item_free(EntityX(item\h),EntityZ(item\h))
				EndIf
			EndIf
		EndIf
	Next
	If pl_tilefauna=1 Then
		If pl_hi>0 Then
			turtlespeak
		EndIf
	EndIf
	;Men Aktionen
	pl_menaction=0
	If pl_tileflora=2 And pl_tilebuild=2 And pl_tilebuildb=0 Then
		pl_menaction=1
	EndIf
	If pl_tilebuild=4 And pl_tilebuildb=0 Then
		pl_menaction=1
	EndIf
	If pl_trade=1 Then
		pl_menaction=1
	EndIf
	If pl_train=1 Then
		pl_menaction=1
	EndIf
End Function

;FreeTile
Function freetile(x,z)
	For e_flora.flora = Each flora
		If Int(EntityX(e_flora\h)/15)=x Then
			If Int(EntityZ(e_flora\h)/15)=z Then
				FreeEntity e_flora\h
				Delete e_flora
			EndIf
		EndIf
	Next
	mapfree(x,z)=0
End Function

;Item Set
Function item_set(x#, z#, typ, pop=1, y#=0, timer=0, age=0)
	Local ha
	If y#=0 Then y#=TerrainY(terrain, x#, y#, z#)+5
	item_free(x#, z#)
	For item.item = Each item
		If EntityX(item\h)=x# Then
			If EntityZ(item\h)=z# Then
				Return 0
			EndIf
		EndIf
	Next
	item.item = New item
	Select typ
		Case 1
			ha = CopyMesh(m_item_ast)
			ScaleEntity ha, 0.1, 0.1, 0.1
		Case 2
			ha = CopyMesh(m_item_leaf)
			ScaleEntity ha, 0.2, 0.2, 0.2
		Case 3
			ha = CopyMesh(m_item_stone)
			ScaleEntity ha, 0.1, 0.1, 0.1
		Case 6
			ha = CopyMesh(m_item_flesh)
			EntityFX ha, 16
			ScaleEntity ha, 0.2, 0.2, 0.2
		Case 7
			ha = CopyMesh(m_item_trunk)
			ScaleEntity ha, 0.2, 0.2, 0.2
		Case 9
			ha = CopyMesh(m_item_stone)
			ScaleEntity ha, 0.05, 0.05, 0.05
		Case 19
			ha = CopyMesh(m_item_smallflesh)
			ScaleEntity ha, 0.2, 0.2, 0.2
		Default 
			ha = CopyMesh(m_item_box)
			ScaleEntity ha, 0.2, 0.2, 0.2
	End Select
	item\typ=typ
	item\h=ha
	item\age=age
	item\timer=timer
	PositionEntity ha, x#,y#,z#
	EntityAutoFade ha, opt_autofade_s, opt_autofade_e
	If pop Then
		PlaySound sfx_pop
		For i=0 To 50
			effect_splatter(x#,y#,z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),80,255,80,1)
		Next
	EndIf
	Return 1
End Function

;Item free
Function item_free(x#, z#)
	For item.item = Each item
		If EntityX(item\h)=x# Then
			If EntityZ(item\h)=z# Then
				FreeEntity item\h
				Delete item
				Return 1
			EndIf
		EndIf
	Next
	Return 0
End Function

;Item take
Function item_take(typ, count=1, msg$="gefunden", msg_noplace$="Kein Platz mehr!")
	Local slot=-1
	pl_itemsgew=0
	For i=0 To 15
		If pl_item(i)>0 Then pl_itemsgew=pl_itemsgew+(pl_itemc(i)*item_gew(pl_item(i)-1))
	Next
	If (pl_itemsgew+(item_gew(typ-1)*count))>pl_take+pl_power*100 Then msg("Objekt ist zu schwer!",1,2) :Return 0
	For i=0 To 15
		If pl_item(i)=typ Then
			slot=i
			Exit
		EndIf
	Next
	If slot=-1 Then
		For i=0 To 15
			If pl_item(i)=0 Then
				slot=i
				Exit
			EndIf
		Next
	EndIf
	If slot=-1 Then msg(msg_noplace$,1,2): Return 0
	pl_item(slot)=typ
	pl_itemc(slot)=pl_itemc(slot)+count
	msg(item_name$(typ-1)+" "+msg$,1,1)
	Return 1
End Function

;Item use
Function item_use(typ, msg$="verwendet", scanonly=0, count=1)
	For i=0 To 15
		If pl_item(i)=typ And pl_itemc(i)>=count Then
			If scanonly=0 Then
				If msg$<>"" Then msg(item_name$(typ-1)+" "+msg$,1,1)
				If pl_itemc(i)>count Then
					pl_itemc(i)=pl_itemc(i)-count
				Else
					pl_item(i)=0
					pl_items(i)=0
					pl_itemc(i)=0
				EndIf
			EndIf
			Return 1
		EndIf
	Next
	Return 0
End Function

;Objekt Type
Function obj_typ(h)
	For e_flora.flora = Each flora
		If e_flora\h = h Then Return e_flora\typ
	Next
	For e_fauna.fauna = Each fauna
		If e_fauna\h = h Then Return e_fauna\typ
	Next
	Return 0
End Function

;Objekt Value
Function obj_value(set=0)
	For flora.flora = Each flora
		If Int(EntityX(flora\h)/15)=pl_tilex Then
			If Int(EntityZ(flora\h)/15)=pl_tiley Then
				If set>0 Then 
					flora\value=set
				Else
					Return flora\value
				EndIf
			EndIf
		EndIf
	Next
	Return 0
End Function

;Grow
Function grow()
	Local x#,y#,z#,yaw#
	;Getreide, Hanf, (Gummi-)Beeren wachsen lassen
	For flora.flora = Each flora
		Select flora\typ
			Case 20
				If flora\value < 3 Then flora\value=flora\value+1
			Case 21
				If flora\value < 3 Then flora\value=flora\value+1
			Case 30
				flora\value=flora\value+1
				If flora\value>=3 Then
					flora\value=0
					yaw#=EntityYaw(flora\h)
					x#=EntityX(flora\h)
					y#=EntityY(flora\h)
					z#=EntityZ(flora\h)
					FreeEntity flora\h
					Delete flora
					terrain_flora_add(x#,y#,z#, 31, 0, yaw#)
				EndIf
			Case 32
				flora\value=flora\value+1
				If flora\value>=5 Then
					flora\value=0
					yaw#=EntityYaw(flora\h)
					x#=EntityX(flora\h)
					y#=EntityY(flora\h)
					z#=EntityZ(flora\h)
					FreeEntity flora\h
					Delete flora
					terrain_flora_add(x#,y#,z#, 33, 0, yaw#)
				EndIf				
		End Select
	Next
	;Reuse fllen
	For building.building = Each building
		Select building\typ
			Case 7
				If building\req_total=0 Then
					If building\mode < 3 Then building\mode=building\mode+1
				EndIf
		End Select
	Next
	;neue Schildkrten bei Schildkrten Eiern erstellen
	i=0
	For fauna.fauna=Each fauna
		If fauna\typ=1 Then i=i+1
	Next
	For flora.flora = Each flora
		If flora\typ=71 Then
			If i<10 Then
				x=EntityX(flora\h)
				z=EntityZ(flora\h)
				terrain_fauna_add(x+Rand(-25,25), 0, z+Rand(-25,25), 1)
				i=i-1
			EndIf
		EndIf
	Next
	;neue Lwen beim Lwenstein erstellen
	i=0
	For fauna.fauna=Each fauna
		If fauna\typ=5 Then i=i+1
	Next
	For flora.flora = Each flora
		If flora\typ=70 Then
			If i<5 Then
				x=EntityX(flora\h)
				z=EntityZ(flora\h)
				terrain_fauna_add(x+Rand(-25,25), 0, z+Rand(-25,25), 5)
				i=i-1
			EndIf
		EndIf
	Next
	;neue Kiwis bei Kiwi Eiern erstellen
	i=0
	For fauna.fauna=Each fauna
		If fauna\typ=8 Then i=i+1
	Next
	For flora.flora = Each flora
		If flora\typ=72 Then
			If i<30 Then
				x=EntityX(flora\h)
				z=EntityZ(flora\h)
				terrain_fauna_add(x+Rand(-25,25), 0, z+Rand(-25,25), 8)
				i=i-1
			EndIf
		EndIf
	Next
	;Items lschen
	For item.item = Each item
		Select item\typ
			Case 1,2,3,6,7,9,19 x=1
			Default x=0
		End Select
		If x=1 Then
			FreeEntity item\h
			Delete item
		EndIf
	Next
	;Hanf Opa repositionieren
	If gm_custom=0 Then
		For fauna.fauna = Each fauna
			If fauna\typ=6 Then
				PositionEntity fauna\h, 70*15, TerrainY(terrain, 70*15, 0, 70*15), 70*15
			EndIf
		Next
	EndIf
	;Hanf Felder vom Hanf-Opa neu anlegen
	If gm_custom=0 Then
		For x=69 To 71
			For y=69 To 71
				terrain_flora_add(x*15, 10, y*15, 21)
			Next
		Next
	EndIf
	;Eingeborenen repositionieren
	If gm_custom=0 Then
		For fauna.fauna = Each fauna
			If fauna\typ=11 Then
				PositionEntity fauna\h, 20*15, TerrainY(terrain, 20*15, 0, 70*15), 70*15
			EndIf
		Next
	EndIf	
End Function

;Turtlespeak
Function turtlespeak()
	Select Rand(0,29)
		Case 0 msg("Schildkrte: Hey, alles frisch?",1,0)
		Case 1 msg("Schildkrte: Ha ha Hallo!",1,0)
		Case 2 msg("Schildkrte: Burn Baby burn, la la la *sing*",1,0)
		Case 3 msg("Schildkrte: Hr mir zu, ich kann sprechen!",1,0)
		Case 4 msg("Schildkrte: Hey du! Hr auf meine Familie abzuschlachten!",1,0)
		Case 5 msg("Schildkrte: Gestrandet? Dumm gelaufen ...",1,0)
		Case 6 msg("Schildkrte: Heute glnzt mein Panzer besonders schn, findest du nicht?",1,0)
		Case 7 msg("Schildkrte: liegende Lachkrmpfe legen lustig Leinen o_O",1,0)
		Case 8 msg("Schildkrte: Opern operieren ohne Ordnung O_o",1,0)
		Case 9 msg("Schildkrte: erntende Ernies erlegen Eier o_O",1,0)
		Case 10 msg("Schildkrte: Igel invasierern Internetcafes international O_o",1,0)
		Case 11 msg("Schildkrte: d4 p4||\|",1,0)
		Case 12 msg("Schildkrte: j00 g37z d4 d0<70r!",1,0)
		Case 13 msg("Schildkrte: b33r in h3r3",1,0)
		Case 14 msg("Schildkrte: w00t",1,0)
		Case 15 msg("Schildkrte: j00 n33d s0m3 p|11z?",1,0)
		Case 16 msg("Schildkrte: <|-||XX0r",1,0)
		Case 17 msg("Schildkrte: www.unrealsoftware.de.vu is |<\/\/|",1,0)
		Case 18 msg("Schildkrte: d4 m4s74 w4n7z j00 t0 b3 3473|\| b4Y d4 1|0|\|",1,0)
		Case 19 msg("Schildkrte: DarkCorner isn  krasser Typ!",1,0)
		Case 20 msg("Schildkrte: <|-|1|| 0|_|7 |/\|17 d4 |/\|33d ||\| j00 p0<|<37Z!",1,0)
		Case 21 msg("Schildkrte: Moh moooooo mohhhh muhahahaha ];B)",1,0)
		Case 22 msg("Schildkrte: gruselig",1,0)
		Case 23 msg("Schildkrte: merkwrdig",1,0)
		Case 24 msg("Schildkrte: 7|-|0|_| 607z d4 b33r!",1,0)
		Case 25 msg("Schildkrte: d0 \/\/|-|47 7|-|0|_| \/\/|17!",1,0)
		Case 26 msg("Schildkrte: www.projectblitz.de!",1,0)
		Case 27 msg("Schildkrte: www.mrkeks.net",1,0)
		Case 28 msg("Schildkrte: Mr.Keks aka Inarie ist toll!",1,0)
		Case 29 msg("Schildkrte: Hbsches Wasser, wa?",1,0)
	End Select
End Function

Global updatecubemap_timer
Function UpdateCubemap(tex,entity)
	If updatecubemap_timer < MilliSecs()
		cam2 = CreateCamera()
		tex_sz=TextureWidth(tex)
		ShowEntity cam2
		HideEntity entity
		PositionEntity cam2,EntityX#(entity),2*waterz-EntityY#(entity),EntityZ#(entity)
		CameraClsMode cam2,False,True
		CameraViewport cam2,0,0,tex_sz,tex_sz
		
		SetCubeFace tex,0
		RotateEntity cam2,0,90,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		SetCubeFace tex,1
		RotateEntity cam2,0,0,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		SetCubeFace tex,2
		RotateEntity cam2,0,-90,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		SetCubeFace tex,3
		RotateEntity cam2,0,180,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		SetCubeFace tex,4
		RotateEntity cam2,-90,0,0
		RenderWorld
		CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		;SetCubeFace tex,5
		;RotateEntity cam2,90,0,0
		;RenderWorld
		;CopyRect 0,0,tex_sz,tex_sz,0,0,BackBuffer(),TextureBuffer(tex)
		
		ShowEntity entity
		FreeEntity cam2
		
		updatecubemap_timer = MilliSecs()+100
	EndIf
End Function


Global updateshadow_timer

Function UpdateShadows()
	If updateshadow_timer < MilliSecs()
		HideEntity camera
		cam = CreateCamera()
		PositionEntity cam,EntityX(camera),100,EntityZ(camera);.2*TerrainSize(terrain),100,TerrainSize(terrain)*.2
		CameraProjMode cam,2
		CameraZoom cam,1.000/128/2.5*2
		
		RotateEntity cam,90,0,0
		
		CameraFogMode cam,1
		CameraFogColor cam,50,50,50
		CameraFogRange cam,0,0
		CameraClsColor cam,255,255,255
		
		HideEntity terrain
		HideEntity water
		HideEntity wet
		HideEntity sky
		HideEntity earth
			
		CameraViewport cam,0,0,ts_s,ts_s
		RenderWorld
		;Color 255,255,255
		;Rect 0,0,ts_s,ts_s
		;Color 255,0,0
		;Rect ts_s/2-32,ts_s/2-32,64,64
		CopyRect 0,0,ts_s,ts_s,0,0,BackBuffer(),TextureBuffer(gfx_tshadow)
		
		ShowEntity terrain
		ShowEntity sky
		ShowEntity water
		ShowEntity wet
		ShowEntity earth
		
		FreeEntity cam
		ShowEntity camera
		
		ScaleTexture gfx_tshadow, 1,1
		blurtexture(gfx_tshadow,1,1)
		PositionTexture gfx_tshadow,0,0
		ScaleTexture gfx_tshadow, 64,64
		PositionTexture gfx_tshadow,.5+EntityX(camera)/128/5*2,.5-EntityZ(camera)/128/5*2;0,0
		TextureBlend gfx_tshadow, 2
		updateshadow_timer = MilliSecs() + 100
	EndIf
End Function