;Welle (ID 1)
Function effect_wave(x#,z#,size#)
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\typ=1
	effect\size#=size#
	effect\alpha#=0.5
	EntityTexture effect\h, gfx_wave
	PositionEntity effect\h, x#, 1.7, z#
	SpriteViewMode effect\h, 2
	RotateEntity effect\h, 90,0,0
	ScaleSprite effect\h, size#, size#
	EntityAlpha effect\h, effect\alpha#
End Function

;Spritzer (ID 2)
Function effect_splash(x#,z#,size#,alpha#)
	effect.effect=New effect
	effect\h=CreateSprite()
	SpriteViewMode effect\h, 4
	EntityTexture effect\h, gfx_splash 
	effect\typ=2
	effect\size#=size# 
	effect\alpha#=alpha#
	effect\age=Rand(0,5)
	PositionEntity effect\h, x#, 5-(effect\size#*1.7)/2, z#
End Function

;Rauchwolke (ID 3)
Function effect_puff(x#,y#,z#,size#,r,g,b,alpha#=1,fy#=0.04)
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\typ=3
	effect\size#=size#
	effect\alpha#=alpha#
	effect\fy#=fy#
	EntityTexture effect\h, gfx_puff
	EntityColor effect\h, r,g,b
	PositionEntity effect\h, x#, y#, z#
	EntityAlpha effect\h, effect\alpha#
	ScaleSprite effect\h, effect\size#,effect\size#
End Function

;Blutspritzer/Sternenregen (ID 4)
Function effect_splatter(x#,y#,z#,size#,fx#,fy#,fz#,r=200,g=0,b=0,mode=0,alpha#=1)
	effect.effect=New effect
	effect\typ=4
	effect\size#=size#
	effect\fx#=fx#
	effect\fy#=fy#
	effect\fz#=fz#
	Select mode
		Case 1
			effect\h=CopyEntity(s_starflare)
			ScaleSprite effect\h, effect\size#,effect\size#
			EntityFX effect\h, 8
		Default
			effect\h=CreateSprite()
			EntityTexture effect\h, gfx_splatter
			ScaleSprite effect\h, effect\size#/10,effect\size#/10
	End Select
	EntityColor effect\h, r,g,b
	PositionEntity effect\h, x#, y#, z#
	EntityAlpha effect\h, alpha#
End Function

;Holzsplitter (ID 5)
Function effect_fragment(x#,y#,z#,size#,fx#,fy#,fz#,r=200,g=100,b=100)
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\typ=5
	effect\size#=size#
	effect\fx#=fx#
	effect\fy#=fy#
	effect\fz#=fz#
	effect\rot#=Rnd(0,360)
	EntityTexture effect\h, gfx_fragment
	EntityColor effect\h, r,g,b
	PositionEntity effect\h, x#, y#, z#
	ScaleSprite effect\h, effect\size#/10,effect\size#/10
	RotateSprite effect\h, effect\rot#
End Function

;Stern (ID 6)
Function effect_star(x#,y#,z#,size#,r,g,b,alpha#=1,fy#=0.04)
	effect.effect=New effect
	effect\h=CopyEntity(s_starflare)
	effect\typ=6
	effect\size#=size#
	effect\alpha#=alpha#
	effect\fy#=fy#
	effect\rot#=Rnd(0,360)
	EntityColor effect\h, r,g,b
	PositionEntity effect\h, x#, y#, z#
	ScaleSprite effect\h, effect\size#,effect\size#
	EntityAlpha effect\h, alpha#
	RotateSprite effect\h, effect\rot#
	EntityFX effect\h, 9
End Function

;Regen (ID 7)
Function effect_rain(x#,z#,size#,fy#=-2)
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\typ=7
	effect\size#=size#
	effect\alpha#=alpha#
	effect\fy#=fy#
	EntityTexture effect\h, gfx_rain
	EntityColor effect\h, 160,160,200
	EntityAlpha effect\h, 0.6
	PositionEntity effect\h, x#, camera_y+30, z#
	ScaleSprite effect\h, effect\size#,effect\size#
End Function

;Steingeschoss (ID 8)
Function effect_stone()
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\age=CreatePivot()
	effect\typ=8
	effect\size#=0.5
	EntityTexture effect\h, gfx_stone
	PositionEntity effect\age, EntityX(camera),EntityY(camera),EntityZ(camera)
	PositionEntity effect\h, EntityX(camera),EntityY(camera),EntityZ(camera)
	RotateEntity effect\age, EntityPitch(camera),EntityYaw(camera),EntityRoll(camera)
	EntityParent effect\h, effect\age
	EntityRadius effect\age, 1
	EntityType effect\age, ct_player
End Function

;Speer (ID 9)
Function effect_spear()
	effect.effect=New effect
	effect\h=CopyEntity(m_spear)
	PositionEntity effect\h, EntityX(camera),EntityY(camera),EntityZ(camera)
	RotateEntity effect\h, EntityPitch(camera),EntityYaw(camera),EntityRoll(camera)
	EntityRadius effect\h, 1
	EntityType effect\h, ct_player
	effect\typ=9
End Function

;Patronenhlse (ID 10)
Function effect_ammo(x#,y#,z#,fx#,fy#,fz#)
	effect.effect=New effect
	effect\h=CreateSprite()
	effect\typ=10
	effect\fx#=fx#
	effect\fy#=fy#
	effect\fz#=fz#
	effect\rot#=Rnd(0,360)
	EntityTexture effect\h, gfx_ammo
	EntityColor effect\h, 200,200,0
	PositionEntity effect\h, x#, y#, z#
	ScaleSprite effect\h, 0.1,0.2
	RotateSprite effect\h, effect\rot#
	EntityRadius effect\h, 0.05
	EntityType effect\h, ct_player
	EntityAlpha effect\h,0.5
End Function


;Effects berrechnen
Function effects()
	For effect.effect = Each effect
		Select effect\typ
			;Welle
			Case 1
				effect\size#=effect\size#+0.04
				ScaleSprite effect\h, effect\size#,effect\size#
				effect\alpha#=effect\alpha#-0.018
				EntityAlpha effect\h, effect\alpha#
				If effect\alpha#<=0.01 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Spritzer
			Case 2
				effect\age=effect\age+1
				If effect\age<17 Then
					effect\size#=effect\size#+0.13
				Else
					effect\size#=effect\size#-0.13
					effect\alpha#=effect\alpha#-0.07
				EndIf
				EntityAlpha effect\h, effect\alpha#
				ScaleSprite effect\h, effect\size#,effect\size#*1.7
				PositionEntity effect\h, EntityX(effect\h), 5-(effect\size#*1.7)/2, EntityZ(effect\h)
				If effect\alpha#<=0.01 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Rauchwolke
			Case 3
				effect\size#=effect\size#+0.02
				ScaleSprite effect\h, effect\size#,effect\size#
				effect\alpha#=effect\alpha#-0.003
				EntityAlpha effect\h, effect\alpha#
				TranslateEntity effect\h,0,effect\fy#,0
				RotateSprite effect\h, gfx_puffrot#
				If effect\alpha#<=0.01 Then
					FreeEntity effect\h
					Delete effect
				EndIf
				gfx_puffrot#=gfx_puffrot#+0.008
			;Blutspritzer/Sternenregen
			Case 4
				effect\fy#=effect\fy#-0.2
				If effect\fx#>0 Then
					effect\fx#=effect\fx#-0.2
				ElseIf effect\fx#<0 Then
					effect\fx#=effect\fx#+0.2
				EndIf
				If effect\fz#>0 Then
					effect\fz#=effect\fz#-0.2
				ElseIf effect\fz#<0 Then
					effect\fz#=effect\fz#+0.2
				EndIf
				TranslateEntity effect\h, effect\fx#, effect\fy#, effect\fz#
				If EntityY(effect\h)<0 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Holzsplitter
			Case 5
				effect\fy#=effect\fy#-0.1
				effect\rot#=effect\rot#+0.02
				If effect\fx#>0 Then
					effect\fx#=effect\fx#-0.2
				ElseIf effect\fx#<0 Then
					effect\fx#=effect\fx#+0.2
				EndIf
				If effect\fz#>0 Then
					effect\fz#=effect\fz#-0.2
				ElseIf effect\fz#<0 Then
					effect\fz#=effect\fz#+0.2
				EndIf
				TranslateEntity effect\h, effect\fx#, effect\fy#, effect\fz#
				RotateSprite effect\h, effect\rot#
				If EntityY(effect\h)<0 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Stern
			Case 6
				effect\alpha#=effect\alpha#-0.003
				effect\rot#=effect\rot#+1
				EntityAlpha effect\h, effect\alpha#
				TranslateEntity effect\h,0,effect\fy#,0
				RotateSprite effect\h, effect\rot#
				If effect\alpha#<=0.01 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Regen
			Case 7
				TranslateEntity effect\h,0,effect\fy#,0
				If EntityY(effect\h)<0 Then
					FreeEntity effect\h
					Delete effect
				EndIf
			;Steingeschoss
			Case 8
				MoveEntity effect\age,0,0,3
				effect\alpha#=effect\alpha#+1
				effect\rot#=effect\rot#-5
				RotateSprite effect\h, effect\rot#
				If EntityY(effect\age)<1.4 Then
					If TerrainY(terrain, EntityX(effect\age),EntityY(effect\age),EntityZ(effect\age))<1.4 Then
						effect_splash(EntityX(effect\age),EntityZ(effect\age),Rnd(0.2,1),Rnd(0.1,0.8))
						effect_wave(EntityX(effect\age),EntityZ(effect\age),1)
						PlaySound sfx_splash
						effect\alpha#=2000
					EndIf
				ElseIf EntityCollided (effect\age,ct_flora) Or EntityCollided(effect\age,ct_fauna) Or EntityCollided (effect\age,ct_slide) Then
					If EntityCollided(effect\age,ct_fauna) Then
						attackanimal(CollisionEntity(effect\age, 1), 10)
					EndIf
					effect_puff(EntityX(effect\age),EntityY(effect\age),EntityZ(effect\age),Rnd(0.05,0.1),150,150,150,Rnd(0.7,0.9), Rnd(0.02,0.03))
					PlaySound sfx_build
					effect\alpha#=2000
				EndIf
				If effect\alpha#>250
					FreeEntity effect\age
					Delete effect
				EndIf
			;Speer
			Case 9
				MoveEntity effect\h,0,0,3
				effect\alpha#=effect\alpha#+1
				If EntityY(effect\h)<1.4 Then
					If TerrainY(terrain, EntityX(effect\h),EntityY(effect\h),EntityZ(effect\h))<1.4 Then
						effect_splash(EntityX(effect\h),EntityZ(effect\h),Rnd(0.2,1),Rnd(0.1,0.8))
						effect_wave(EntityX(effect\h),EntityZ(effect\h),1)
						PlaySound sfx_splash
						effect\alpha#=2000
					EndIf
				ElseIf EntityCollided (effect\h,ct_flora) Or EntityCollided(effect\h,ct_fauna) Or EntityCollided (effect\h,ct_slide) Then
					If EntityCollided(effect\h,ct_fauna) Then
						attackanimal(CollisionEntity(effect\h, 1), 200)
					EndIf
					effect_puff(EntityX(effect\h),EntityY(effect\h),EntityZ(effect\h),Rnd(0.05,0.1),150,150,150,Rnd(0.7,0.9), Rnd(0.02,0.03))
					PlaySound sfx_build
					effect\alpha#=2000
				EndIf
				If effect\alpha#>250
					FreeEntity effect\h
					Delete effect
				EndIf
			;Partonenhlsen
			Case 10
				If EntityCollided(effect\h,ct_flora) Then
					TranslateEntity effect\h, 0, -0.2, 0
					effect\age=effect\age+1
					If effect\age>50 Then
						FreeEntity effect\h
						Delete effect	
					EndIf					
				Else
					effect\rot#=effect\rot#+5
					RotateSprite effect\h, effect\rot#
					effect\fy#=effect\fy#-0.2
					If effect\fx#>0 Then
						effect\fx#=effect\fx#-0.2
					ElseIf effect\fx#<0 Then
						effect\fx#=effect\fx#+0.2
					EndIf
					If effect\fz#>0 Then
						effect\fz#=effect\fz#-0.2
					ElseIf effect\fz#<0 Then
						effect\fz#=effect\fz#+0.2
					EndIf
					TranslateEntity effect\h, effect\fx#, effect\fy#, effect\fz#
				EndIf
		End Select
	Next
End Function