;Stranded - Editor File
Function editor()
	Local timerrun=0

	;Cachen
	ms=MilliSecs()
	
	;Timer 1 (alle 30ms)
	If ms-timer1>=30 Then
		timer1=ms
		timerrun=1
		
		;Camera Cachen
		camera_x#=EntityX(camera)
		camera_y#=EntityY(camera)
		camera_z#=EntityZ(camera)
		
		;Sky
		PositionEntity sky, camera_x#, 0, camera_z#
		RotateEntity sky,0,EntityYaw(sky)+0.2,0
			
		;Water
		watero#=watero# + 0.0002
		watero2#=watero2# + 0.0004
		wetalpha#=wetalpha#-0.005
		EntityAlpha wet, wetalpha#
		;HideEntity wet
		If watermode=0 Then
			watery#=watery#-0.01
			If watery#<0.5 Then watermode=1
		Else
			watery#=watery#+0.01
			If watery#>1.5 Then watermode=0: wetalpha#=0.8
		EndIf
		PositionEntity water, 0, watery#, 0
		PositionTexture gfx_water3, watero#, watero#
		UpdateCubemap(gfx_water,camera)
		PositionTexture gfx_water2, watero2#, watero2#
		
		UpdateShadows()  
		
		;Lensflares
		lensflares()
		
		;Effecte
		effects()
					
		;Cachen
		mxs#=-MouseXSpeed()/opt_msens#
		mys#=MouseYSpeed()/opt_msens#
		mx=MouseX()
		my=MouseY()
		mh=MouseHit(1)
		md=MouseDown(1)
		md2=MouseDown(2)

		
		;Drehen
		If md2=1 Then
			If mxs#<>0 Then RotateEntity camera,EntityPitch(camera),EntityYaw(camera)+mxs,EntityRoll(camera)
			If mys#<>0 Then
				If mys>0 Then
					If EntityPitch(camera)+mys>70
						mys=70-EntityPitch(camera)
					EndIf
					RotateEntity camera,EntityPitch(camera)+mys,EntityYaw(camera),EntityRoll(camera)
				ElseIf mys<0 Then
					If EntityPitch(camera)+mys<-70
						mys=-70-EntityPitch(camera)
					EndIf
					RotateEntity camera,EntityPitch(camera)+mys,EntityYaw(camera),EntityRoll(camera)
				EndIf
			EndIf
		EndIf
		
		;Bewegen
		If gui_messageon=0 Then
			If KeyDown(31) Then MoveEntity camera,0,0,-1	;Rckwrts
			If KeyDown(17) Then MoveEntity camera,0,0,1		;Vorwrts
			If KeyDown(30) Then MoveEntity camera,-1,0,0	;Links
			If KeyDown(32) Then MoveEntity camera,1,0,0		;Rechts
			If EntityY(camera)-3<TerrainY(terrain, EntityX(camera),0,EntityZ(camera)) Then
				PositionEntity camera, EntityX(camera),TerrainY(terrain, EntityX(camera),0,EntityZ(camera))+3,EntityZ(camera)
			ElseIf EntityY(camera)>250 Then
				PositionEntity camera, EntityX(camera),250,EntityZ(camera)
			EndIf
		EndIf
		
		;Ende
		If KeyHit(1) Then Return 1
		
		;F-Tasten
		If KeyHit(63) Then SaveBuffer(FrontBuffer(), "screenshot"+Rand(1000,9999)+".bmp")	;Screenshot
		If KeyHit(64) Then grid()															;Grid
		If KeyHit(65) Then wire=1-wire : WireFrame wire										;Wireframe
		If KeyHit(66) Then opt_debug=1-opt_debug											;Debug
			
		;Objekte drehen
		For i=0 To 3
			TurnEntity ed_h(i), 0,1,0
		Next
				
	EndIf
	
	;Rendern
	RenderGlow
	RenderWorld
	
	;2D Stuff
	gui_mx=0
	gui_my=0
	Color 255,255,255
	SetFont font_menu
	Text 5,0, "Stranded Editor"
	SetFont font_norm
	
	;Men
	If gui_button(5,35,"Neue Map",0,1) Then mh=0:message_set(220)
	If gui_button(5,55,"Speichern",0,1) Then mh=0:PositionEntity pivot, EntityX(camera),EntityY(camera)-3,EntityZ(camera):message_set(221)
	If gui_button(5,75,"Laden",0,1) Then mh=0:message_set(222)
	If gui_button(5,115,"Ziele",0,1) Then mh=0:message_set(223)
	If gui_button(5,135,"Einstellungen",0,1) Then mh=0:message_set(224)
	If gui_button(5,155,"Spieler Werte",0,1) Then mh=0:message_set(225)
	If gui_button(5,195,"Heightmap laden",0,1) Then mh=0:message_set(226)
	If gui_button(5,215,"Textur laden",0,1) Then mh=0:message_set(227)
	If gui_button(5,245,"Insel fllen",0,1) Then mh=0:message_set(228)
	
	;"Symbol"-Leiste
	For i=0 To 3
		If ed_selcat=i Then
			Color 80,255,80 : Rect 150+i*75, 5, 70,70,0
			Color 255,255,255: SetFont font_tiny : Text 154+i*75,5, ed_name$(i)
			If gui_button(152+i*75,60,"<<",0,1) And timerrun Then ed_select(i, ed_sel(i)-1):mh=0
			If gui_button(203+i*75,60,">>",0,1) And timerrun Then ed_select(i, ed_sel(i)+1):mh=0
			EntityAlpha ed_h(i),1
		Else
			Color 255,255,255 : Rect 150+i*75, 5, 70,70,0
			EntityAlpha ed_h(i),0.2
		EndIf
		
		If mh Then
			If mx>=150+i*75 And my>=5 And mx<=220+i*75 And my<= 75 Then
				ed_selcat=i
				mh=0
			EndIf
		EndIf		
	Next
	
	;Minimap
	DrawImage gfx_minimap, 150+4*75, 5
	If camera_x>0 And camera_x<1275 And camera_z>0 And camera_z<1275 Then
		Color 255,255,255 : Rect 150+4*75, 5, 70,70,0
		Oval ((150+4*75)+(camera_x/18.214286))-2, (5+(camera_z/18.214286))-2, 4,4
	Else
		Color 80,255,80 : Rect 150+4*75, 5, 70,70,0
	EndIf
	If mh Then
		If mx>(150+4*75) Then
			If mx<(150+4*75)+70 Then
				If my>5 Then
					If my<75 Then
						PositionEntity camera, (mx-(150+4*75))*18.214286,EntityY(camera), (my-5)*18.214286
						ed_minimap()
						mh=0
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf

	
	;Message fr Mens
	If ms-timer_gui>=25 Then
		timer_gui=ms
		timer_gui_run=1
		gui_blink = gui_blink + 1
		If gui_blink >= 20 Then gui_blink=0
	Else
		timer_gui_run=0
	EndIf
	message_draw(gui_message)
	
	;Actions
	If mh=1 Then
		mh=0
		CameraPick(camera,mx,my)
		x#=PickedX()
		y#=PickedY()
		z#=PickedZ()
		For i=0 To 3
			effect_splatter(x#,y#,z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),80,255,80,1)
		Next
		Select ed_selcat
			Case 0
				x#=Int(x#/5)
				z#=Int(z#/5)
				If y#<0.0000 Then y#=0.0
				Select ed_id(ed_selcat)
					Case 1 ed_transform(x#,z#,0.005)
					Case 2 ed_transform(x#,z#,-0.005)
					Case 3 ed_transform(x#,z#,0.0,1)
					Case 4 ed_transform(x#,z#,0.2,1)
					Case 5 ed_transform(x#,z#,0.4,1)
					Case 6 ed_delete(x#*5,z#*5)
					Case 7 ed_turn(x#*5,z#*5,45)
					Case 8 ed_turn(x#*5,z#*5,0,1)
					Case 9 ed_turn(x#*5,z#*5,90,1)
				End Select
			Case 1
				terrain_flora_add(15*Int(x#/15),0,15*Int(z#/15),ed_id(ed_selcat))
			Case 2
				terrain_fauna_add(15*Int(x#/15),0,15*Int(z#/15),ed_id(ed_selcat))
			Case 3
				terrain_building_add(15*Int(x#/15),0,15*Int(z#/15),ed_id(ed_selcat))
		End Select
	EndIf
		
	;Debug
	If opt_debug=1 Then
		Color 255,255,255
		SetFont font_tiny
		If ms-fpsm>1000 Then
			fps=fpst
			fpst=0
			fpsm=ms
		EndIf
		fpst=fpst+1
		Text 5,23,"FPS: "+fps+"  Triangles: "+TrisRendered()
	EndIf
		
	;Zeiger
	If md2=0 Then
		DrawImage gfx_gui_pointer, mx,my
	Else
		DrawImage gfx_gui_pointerc, mx,my
	EndIf
	
	;Grid repositionieren
	If grid=1 Then
		PositionEntity grid_master, 0,TerrainY(terrain, camera_x#, camera_y#, camera_z#)-25,0
	EndIf
	
	;Timer 2 (alle 50ms)
	If ms-timer2>=50 Then
		timer2=ms
		
		cull(1,0)
		
	EndIf
	
	
	;Flippen
	Flip opt_vsync
	
End Function



;Terrain Option
Function ed_select(cat,value)
	Local h, scale#=1,name$,id=0,yoff=0
	If value<=0 Then Return 0
	Select cat
		Case 0
			If value>=10 Then Return 0
			Select value
				Case 1 : h=CopyMesh(m_arrow,camera):EntityColor h,80,255,80:name$="erhhen":id=1:scale#=5
				Case 2 : h=CopyMesh(m_arrow,camera):TurnEntity h,180,0,0:EntityColor h,80,255,80:name$="absenken":id=2:scale#=5
				Case 3 : h=CreateCube(camera):EntityColor h,255,0,0:name$="niedrig":id=3:scale#=15
				Case 4 : h=CreateCube(camera):EntityColor h,255,255,0:name$="mittel":id=4:scale#=20
				Case 5 : h=CreateCube(camera):EntityColor h,0,255,0:name$="hoch":id=5:scale#=25
				Case 6 : h=CreateCube(camera):EntityColor h,255,150,0:name$="Obj. lschen":id=6:scale#=25
				Case 7 : h=CopyMesh(m_arrow,camera):TurnEntity h,0,0,90:EntityColor h,255,150,0:name$="Obj. drehen":id=7:scale#=5
				Case 8 : h=CreateCube(camera):EntityColor h,255,150,0:name$="Obj. auf 0":id=8:scale#=25
				Case 9 : h=CreateCube(camera):EntityColor h,255,150,0:name$="Obj. auf 90":id=9:scale#=25
			End Select
		Case 1
			If value>=30 Then Return 0
			Select value
				Case 1 : h=CopyMesh(m_palm1,camera):name$="Palme":id=1:scale#=1.8
				Case 2 : h=CopyMesh(m_palm2,camera):name$="Riesen Palme":id=2.4
				Case 3 : h=CopyMesh(m_palm3,camera):name$="Bananen P.":id=3:scale#=2
				Case 4 : h=CopyMesh(m_palm4,camera):name$="Palme":id=4:scale#=1.8
				Case 5 : h=CopyMesh(m_palm5,camera):name$="Palme":id=5:scale#=1.3
				Case 6 : h=CopyMesh(m_drytree,camera):name$="kahler Baum":id=6:scale#=2:yoff=25
				Case 7 : h=CopyMesh(m_palm6,camera):name$="Palme":id=7:scale#=1.7
				Case 8 : h=CopyMesh(m_gras,camera):name$="Gras":id=10:scale#=5:yoff=35
				Case 9 : h=CopyMesh(m_corn,camera):name$="Getreide":id=20:scale#=2.3:yoff=40
				Case 10 : h=CopyMesh(m_hemp,camera):name$="Hanf":id=21:scale#=2:yoff=35
				Case 11 : h=CopyMesh(m_bush1,camera):name$="Beeren leer":id=30:scale#=3:yoff=35
				Case 12 : h=CopyMesh(m_bush1b,camera):name$="Beeren voll":id=31:scale#=3:yoff=35
				Case 13 : h=CopyMesh(m_bush1,camera):name$="Gummib. leer":id=32:scale#=3:yoff=35
				Case 14 : h=CopyMesh(m_bush1c,camera):name$="Gummib. voll":id=33:scale#=3:yoff=35
				Case 15 : h=CopyMesh(m_bush2,camera):name$="Busch":id=40:scale#=3:yoff=35
				Case 16 : h=CopyMesh(m_bush3,camera):name$="Busch":id=41:scale#=3:yoff=35
				Case 17 : h=CopyMesh(m_bush4,camera):name$="Busch":id=42:scale#=3:yoff=35
				Case 18 : h=CopyMesh(m_bush5,camera):name$="Busch":id=43:scale#=3:yoff=35
				Case 19 : h=CopyMesh(m_stone1,camera):name$="Stein":id=50:scale#=2
				Case 20 : h=CopyMesh(m_stone2,camera):name$="Stein spitz":id=51:scale#=2
				Case 21 : h=CopyMesh(m_stone1,camera):name$="Quelle":id=52:scale#=2
				Case 22 : h=CopyMesh(m_flowers,camera):name$="Blumen 1":id=60:scale#=2.2
				Case 23 : h=CopyMesh(m_flowers2,camera):name$="Blumen 2":id=61:scale#=2.2
				Case 24 : h=CopyMesh(m_flowers3,camera):name$="Blumen 3":id=62:scale#=2.2
				Case 25 : h=CopyMesh(m_flowers4,camera):name$="Blumen 4":id=63:scale#=2.2
				Case 26 : h=CopyMesh(m_lionstone,camera):name$="Lwenstein":id=70:scale#=1.7
				Case 27 : h=CopyMesh(m_eggs,camera):name$="Schilkr. Eier":id=71:scale#=7
				Case 28 : h=CopyMesh(m_eggs,camera):name$="Kiwi Eier":id=72:scale#=5
				Case 29 : h=CopyMesh(m_tree1,camera):name$="Tanne":id=8:scale#=1.8:yoff=8
			End Select
		Case 2
			If value>=12 Then Return 0
			Select value
				Case 1 : h=CopyMesh(m_turtle,camera):name$="Schildkrte":id=1:scale#=2.3
				Case 2 : h=CopyMesh(m_cancer,camera):name$="Krebs":id=2:scale#=2.2
				Case 3 : h=CopyMesh(m_flower,camera):name$="Giftplfanze":id=3:scale#=1.8
				Case 4 : h=CopyMesh(m_butterfly,camera):name$="Schmetterl.":id=4:scale#=2.6
				Case 5 : h=CopyMesh(m_lion,camera):name$="Lwe":id=5:scale#=2.5:yoff=20
				Case 6 : h=CopyMesh(m_oldman,camera):name$="Hanf-Opa":id=6:scale#=4.0:yoff=40
				Case 7 : h=CopyMesh(m_kiwi,camera):name$="Kiwi":id=8:scale#=4.0:yoff=25
				Case 8 : h=CopyMesh(m_raptor,camera):name$="Raptor":id=9:scale#=1.4:yoff=0
				Case 9 : h=CopyMesh(m_soldier,camera):name$="Soldat":id=10:scale#=2.3:yoff=45
				Case 10 : h=CopyMesh(m_native,camera):name$="Eingeborener":id=11:scale#=2.3:yoff=45
				Case 11 : h=CopyMesh(m_bird,camera):name$="Vogel":id=12:scale#=1.8
			End Select
		Case 3
			If value>=20 Then Return 0
			Select value
				Case 1 : h=CopyMesh(m_house,camera):name$="Htte":id=1
				Case 2 : h=CopyMesh(m_treehouse,camera):name$="Baumhaus":id=2:scale#=1.2:yoff=-10
				Case 3 : h=CopyMesh(m_fire,camera):name$="Feuerstelle":id=3:scale#=2.5
				Case 4 : h=CopyMesh(m_boat,camera):name$="Flo":id=4:scale#=2:yoff=30
				Case 5 : h=CopyMesh(m_torch,camera):name$="Fackel":id=5:scale#=1.8
				Case 6 : h=CopyMesh(m_storage,camera):name$="Lager":id=6:scale#=1.7:yoff=-20
				Case 7 : h=CopyMesh(m_reuse,camera):name$="Reuse":id=7:scale#=3
				Case 8 : h=CopyMesh(m_checkp,camera):name$="Checkpoint":id=10:scale#=2.5:yoff=30
				Case 9 : h=CopyMesh(m_finish,camera):name$="Ziel":id=11:scale#=2:yoff=40
				Case 10 : h=CopyMesh(m_kiwip,camera):name$="Kiwi Ziel":id=12:scale#=2:yoff=40
				Case 11 : h=CopyMesh(m_wreck,camera):name$="Schiffswrack":id=20:scale#=0.9:yoff=0
				Case 12 : h=CopyMesh(m_wall,camera):name$="Wand":id=21:scale#=1.3:yoff=35
				Case 13 : h=CopyMesh(m_wallc,camera):name$="Wand Ecke":id=22:scale#=1.3:yoff=35
				Case 14 : h=CopyMesh(m_cammo,camera):name$="Muntion":id=25:scale#=2.5:yoff=30
				Case 15 : h=CopyMesh(m_cpistol,camera):name$="Pistole":id=26:scale#=2.5:yoff=30
				Case 16 : h=CopyMesh(m_cak,camera):name$="AK":id=27:scale#=2.5:yoff=30
				Case 17 : h=CopyMesh(m_spikes,camera):name$="Stacheln":id=30:scale#=1.5:yoff=0
				Case 18 : h=CopyMesh(m_smallstake,camera):name$="kleiner Pfahl":id=31:scale#=1.3:yoff=40
				Case 19 : h=CopyMesh(m_stake,camera):name$="Pfahl":id=32:scale#=1.8:yoff=40
			End Select
	End Select
	If id=0 Then h=CreateCube(camera):scale#=25:EntityColor h,255,0,0
	If ed_h(cat)<>0 Then
		FreeEntity ed_h(cat)
		ed_h(cat)=0
	EndIf
	ed_name$(cat)=name$
	ed_h(cat)=h
	ed_id(cat)=id
	ed_sel(cat)=value
	EntityOrder ed_h(cat), -4
	If cat=0 Then
		EntityFX ed_h(cat), 25
	Else
		EntityFX ed_h(cat), 24
	EndIf
	ScaleMesh ed_h(cat),scale#,scale#,scale#
	PositionEntity ed_h(cat), (330+cat*150)-(opt_sx)+38,-(45+yoff)-38+(opt_sy), opt_sx 
	Return 1
End Function

;Manipulieren
Function ed_transform(xp#,zp#,offset#,absolut=0,range#=1.000)
	Local x#,z#,y#,do=1
	For x#=xp#-range# To xp#+range#
		For z#=zp#-range# To zp#+range#
			If absolut=0 Then
				y#=TerrainHeight(terrain,x#,z#)
				do=1
				If y#+offset#>1 Then do=0
				If y#+offset#<0 Then do=0
				If do Then ModifyTerrain(terrain,x#,z#,y#+offset#,0)
			Else
				ModifyTerrain(terrain,x#,z#,offset#,0)
			EndIf
			For flora.flora = Each flora
				If Int(EntityX(flora\h)/15) = Int((x#*5)/15) Then
					If Int(EntityZ(flora\h)/15) = Int((z#*5)/15) Then
						FreeEntity flora\h
						Delete flora
					EndIf
				EndIf
			Next
			For fauna.fauna = Each fauna
				If Int(EntityX(fauna\h)/15) = Int((x#*5)/15) Then
					If Int(EntityZ(fauna\h)/15) = Int((z#*5)/15) Then
						FreeEntity fauna\h
						Delete fauna
					EndIf
				EndIf
			Next
			For building.building = Each building
				If Int(EntityX(building\h1)/15) = Int((x#*5)/15) Then
					If Int(EntityZ(building\h1)/15) = Int((z#*5)/15) Then
						FreeEntity building\h1
						FreeEntity building\h2
						FreeEntity building\h3
						Delete building
					EndIf
				EndIf
			Next
		Next
	Next
	UpdateWorld
End Function

;Drehen
Function ed_turn(x#,z#,turn#, total=0)
	mh=0
	Local h
	For flora.flora = Each flora
		If Int(EntityX(flora\h)/15) = Int((x#)/15) Then
			If Int(EntityZ(flora\h)/15) = Int((z#)/15) Then
				h=flora\h
				RotateEntity h, EntityPitch(h),EntityYaw(h)+turn#,EntityRoll(h)
				If total Then RotateEntity h, EntityPitch(h),turn#,EntityRoll(h)
			EndIf
		EndIf
	Next
	For fauna.fauna = Each fauna
		If Int(EntityX(fauna\h)/15) = Int((x#)/15) Then
			If Int(EntityZ(fauna\h)/15) = Int((z#)/15) Then
				h=fauna\h
				RotateEntity h, EntityPitch(h),EntityYaw(h)+turn#,EntityRoll(h)
				If total Then RotateEntity h, EntityPitch(h),turn#,EntityRoll(h)
			EndIf
		EndIf
	Next
	For building.building = Each building
		If Int(EntityX(building\h1)/15) = Int((x#)/15) Then
			If Int(EntityZ(building\h1)/15) = Int((z#)/15) Then
				h=building\h1
				RotateEntity h, EntityPitch(h),EntityYaw(h)+turn#,EntityRoll(h)
				If total Then RotateEntity h, EntityPitch(h),turn#,EntityRoll(h)
			EndIf
		EndIf
	Next
End Function

;Lschen
Function ed_delete(x#,z#)
	mh=0
	For flora.flora = Each flora
		If Int(EntityX(flora\h)/15) = Int((x#)/15) Then
			If Int(EntityZ(flora\h)/15) = Int((z#)/15) Then
				FreeEntity flora\h
				Delete flora
			EndIf
		EndIf
	Next
	For fauna.fauna = Each fauna
		If Int(EntityX(fauna\h)/15) = Int((x#)/15) Then
			If Int(EntityZ(fauna\h)/15) = Int((z#)/15) Then
				FreeEntity fauna\h
				Delete fauna
			EndIf
		EndIf
	Next
	For building.building = Each building
		If Int(EntityX(building\h1)/15) = Int((x#)/15) Then
			If Int(EntityZ(building\h1)/15) = Int((z#)/15) Then
				FreeEntity building\h1
				FreeEntity building\h2
				FreeEntity building\h3
				Delete building
			EndIf
		EndIf
	Next
End Function

;Minimap updaten
Function ed_minimap()
	Local x,y,h#,rgb
	SetBuffer ImageBuffer(gfx_minimap)
	Color 255,0,255
	Rect 0,0,70,70,1
	For x=0 To 70 Step 3
		For y=0 To 70 Step 3
			h#=TerrainHeight(terrain,x*3.6571428,y*3.6571428)
			rgb=h#*3000
			Color rgb,rgb,rgb
			Plot x,y
		Next
	Next
	SetBuffer BackBuffer()
End Function