 ;Stranded - Mainfile
.reset
AppTitle "Stranded"
SeedRnd MilliSecs()

;Includes
Include "includes/load.bb"
Include "includes/effects.bb"
Include "includes/infos_items.bb"
Include "includes/infos_credits.bb"
Include "includes/infos_msgs.bb"
Include "includes/infos_useitems.bb"
Include "includes/infos_combineitems.bb"
Include "includes/ki.bb"
Include "includes/terrain.bb"
Include "includes/menu.bb"
Include "includes/flora.bb"
Include "includes/lensflares.bb"
Include "includes/editor.bb"

;Men
.menu
updatelight(150)
leave=menu()
If leave=1 Then
	Goto game
ElseIf leave=3 Then
	Goto editor
Else
	Goto reset
EndIf



;-----------------------------------------------Hauptschleife
.game

updatelight(150)

If loadsaved$<>"" Then
	If Not game_load(loadsaved$,loaddir$) Then
		game_new()
	EndIf
Else
	game_new()
EndIf



Repeat

	;Cachen
	ms=MilliSecs()
	looptime=MilliSecs()

	
		;Timer 1 (alle 30ms)
		If ms-timer1>=30 Then
			timer1=ms
					
			;Multidown
			multidown=multidown-1
			
			;Camera Cachen
			camera_x#=EntityX(pivot)
			camera_y#=EntityY(pivot)
			camera_z#=EntityZ(pivot)
			
			;Sky
			PositionEntity sky, camera_x#, 0, camera_z#
			RotateEntity sky,0,EntityYaw(sky)+0.2,0
				
			;Water
			watero#=watero# + 0.0002
			watero2#=watero2# + 0.0004
			wetalpha#=wetalpha#-0.005
			EntityAlpha wet, wetalpha#
			;HideEntity wet
			If watermode=0 Then
				watery#=watery#-0.01
				If watery#<0.5 Then watermode=1
			Else
				watery#=watery#+0.01
				If watery#>1.5 Then watermode=0: wetalpha#=0.8
			EndIf
			PositionEntity water, 0, watery#, 0
			PositionTexture gfx_water3, watero#, watero#
			UpdateCubemap(gfx_water,camera)
			PositionTexture gfx_water2, watero2#, watero2#
			
			;Lensflares
			lensflares()
					
			;Schatten
			UpdateShadows()  
				
			;Cachen
			mxs#=-MouseXSpeed()/opt_msens#
			mys#=MouseYSpeed()/opt_msens#
			If gui_on=0 And gui_messageon=0 Then MoveMouse(opt_sx/2,opt_sy/2)
			mx=MouseX()
			my=MouseY()
			mh=MouseHit(1)
			md=MouseDown(1)
			
			;Eingabe mit und ohne Pause
			If KeyHit(63) Then SaveBuffer(FrontBuffer(), "screenshot"+Rand(1000,9999)+".bmp")	;Screenshot
			If KeyHit(64) Then grid()															;Grid
			If KeyHit(65) Then wire=1-wire :  WireFrame wire										;Wireframe
			If KeyHit(66) Then opt_debug=1-opt_debug											;Debug
			If KeyHit(46) Then
				If KeyDown(29) And KeyDown(56) Then
					FlushKeys()
					message_set(202)
					enter$=""
				EndIf
			EndIf
			If KeyHit(1) Then
				If script<>0 Then
					Exit
				Else
					gui_on=1
					gui_menu=2
				EndIf
			EndIf
				
					
			;Nur ohne Pause:
			If gamestop=0 Then
				
				;Gametime
				gametime()
					
				;Steuerung
				
				;Drehen
				If gui_on=0 And gui_messageon=0 Then
					If mxs#<>0 Then RotateEntity camera,EntityPitch(camera),EntityYaw(camera)+mxs,EntityRoll(camera)
					If mys#<>0 Then
						If mys>0 Then
							If EntityPitch(camera)+mys>70
								mys=70-EntityPitch(camera)
							EndIf
							RotateEntity camera,EntityPitch(camera)+mys,EntityYaw(camera),EntityRoll(camera)
						ElseIf mys<0 Then
							If EntityPitch(camera)+mys<-70
								mys=-70-EntityPitch(camera)
							EndIf
							RotateEntity camera,EntityPitch(camera)+mys,EntityYaw(camera),EntityRoll(camera)
						EndIf
					EndIf
				EndIf
				RotateEntity pivot,EntityPitch(camera),EntityYaw(camera),0
				
				
				If pl_actiontotal=0 Then
				
					;Respawn Positions Bug beheben
					If c_respawn_timer>0 Then    
						c_respawn_timer=c_respawn_timer-1
						PositionEntity pivot, c_respawn_x#,c_respawn_y#,c_respawn_z#
						;Briefing
						If c_respawn_timer=1 Then
							If gm_briefing$<>"" Then
								If message_load(gm_briefing$) Then message_set(210)
							EndIf
						EndIf
					EndIf
					
					;Bewegen - Player
					If EntityY(pivot)<0 Then PositionEntity pivot,EntityX(pivot), 15, EntityZ(pivot)
					If pl_drive=0 Then
						pl_multimove=0
						If KeyDown(31) Then move(-90)	;Rckwrts
						If KeyDown(17) Then move(90)	;Vorwrts
						If KeyDown(30) Then move(180)	;Links
						If KeyDown(32) Then move(0)		;Rechts
						;Strmung
						If EntityX(camera)<0 Then
							TranslateEntity pivot,(0-EntityX(camera))/50,0,0
						ElseIf EntityX(camera)>(msz*15) Then
							TranslateEntity pivot,((msz*15)-EntityX(camera))/50,0,0
						EndIf
						If EntityZ(camera)<0 Then
							TranslateEntity pivot,0,0,(0-EntityZ(camera))/50
						ElseIf EntityZ(camera)>(msz*15) Then
							TranslateEntity pivot,0,0,((msz*15)-EntityZ(camera))/50
						EndIf
					;Bewegen - Flo
					Else
						If pl_driveacc#<>0.0 Then
							If pl_driveacc#>0.0 Then
								pl_driveacc#=pl_driveacc#-0.02
							Else
								pl_driveacc#=pl_driveacc#+0.02
							EndIf
						EndIf
						If pl_driveacc#>1.5 Then pl_driveacc#=1.5
						If pl_driveacc#<-1.0 Then pl_driveacc#=-1.0
						If KeyDown(31) Then pl_driveacc#=pl_driveacc#-0.04
						If KeyDown(17) Then pl_driveacc#=pl_driveacc#+0.04
						If KeyDown(30) Then TurnEntity pl_driveh,0,1.3,0
						If KeyDown(32) Then TurnEntity pl_driveh,0,-1.3,0
						MoveEntity pl_driveh,0,0,pl_driveacc#
						If pl_driveacc#>0.02 Then
							down(1)
							effect_wave(camera_x#,camera_z#,5)
						ElseIf pl_driveacc#<-0.02
							down(1)
							effect_wave(camera_x#,camera_z#,5)
						EndIf
						If TerrainY(terrain, EntityX(pl_driveh), 0, EntityZ(pl_driveh))>0.5 Then
							MoveEntity pl_driveh,0,0,-pl_driveacc#
							pl_driveacc#=0
						EndIf
						PositionEntity pivot, EntityX(pl_driveh),EntityY(pl_driveh)+11,EntityZ(pl_driveh)
						;Win?!
						If gm_mi_distance<>0 Then
							If EntityX(camera) < -gm_mi_distance Then
								script_run(4)
							ElseIf EntityX(camera) > gm_mi_distance+(msz*15) Then
								script_run(4)
							ElseIf EntityZ(camera) < -gm_mi_distance Then
								script_run(4)
							ElseIf EntityZ(camera) > gm_mi_distance+(msz*15) Then
								script_run(4)
							EndIf
						EndIf
					EndIf
					
					;Springen
					If KeyDown(57) And pl_jumpmode=0 Then
						x=1
						If EntityCollided(pivot,ct_slide) Then
							If Not EntityCollided(cpivot,ct_slide) Then
								x=0
							EndIf
						EndIf
						If x=1 Then
							pl_jumpmode=1
							pl_jumpspeed#=2		
							If pl_rubber>0 Then
								PlaySound sfx_jump
								pl_jumpspeed#=5
							EndIf
						EndIf
					EndIf
					
					;HUD an/aus
					If KeyHit(28) Or MouseHit(2) Then gui_on=1-gui_on
					
					;Tool per Tastatur ndern
					If KeyHit(2) settool(0)
					If KeyHit(3) settool(9)
					If KeyHit(4) settool(8)
					If KeyHit(5) settool(7)
					If KeyHit(6) settool(6)
					If KeyHit(7) settool(5)
					If KeyHit(8) settool(4)
					If KeyHit(9) settool(3)
					If KeyHit(10) settool(2)
					If KeyHit(11) settool(1)
					
					;Tool per Mausrad ndern
					mzsp=MouseZSpeed()
					If mzsp Then
						If mzsp>0 Then
							x=pl_tool-1
							While Not settool(x)
								x=x-1
								If x<0 Then x=9
							Wend
						Else
							x=pl_tool+1
							While Not settool(x)
								x=x+1
								If x>8 Then x=0
							Wend
						EndIf
					EndIf
					
					;Suchen
					If KeyHit(18) And gui_on=0 And gui_messageon=0 Then a_search() 
					
					;Attack
					If md And gui_on=0 And gui_messageon=0 Then attack()
					
					;Quicksave Quickload
					If KeyHit(61) Then game_save("quicksave",0)
					If KeyHit(62) Then game_load("quicksave")
					
				EndIf
				
				;Pause
				If KeyHit(25) Then pause=1: gamestop=1
			
				;Progress
				If pl_toolakt>0 Then pl_toolakt=pl_toolakt-1
				If pl_actionakt<pl_actiontotal Then pl_actionakt=pl_actionakt+1
				If mflasht>0 Then
					mflasht=mflasht-1
					If mflasht=0 Then HideEntity mflash
				EndIf
				
				;Tile
				If pl_tilex<>Int(EntityX(pivot)/15) Or pl_tiley<>Int(EntityZ(pivot)/15) Then
					scantile()
				EndIf
				
				;Springen
				If pl_jumpmode=1 Then
					pl_jumpspeed#=pl_jumpspeed#-0.2
					TranslateEntity pivot,0,pl_jumpspeed#,0
					If pl_jumpspeed#<=0.5 Then pl_jumpmode=2
				EndIf	
				
				;Fallen
				If pl_jumpmode<>1 And pl_jumpmode<>-100 Then 
					If EntityCollided(pivot,ct_flora) Or EntityCollided(pivot,ct_fauna) Or EntityCollided(pivot,ct_slide) Then
						If pl_fallspeed# > 1
							If EntityY(pivot)<3.6  Then
								PlaySound sfx_splash
								For i=0 To (pl_fallspeed#)+5
									effect_splash(camera_x#+Rnd(-3,3),camera_z#+Rnd(-3,3),Rnd(0.2,1),Rnd(0.1,0.8))
									effect_splatter(camera_x#, camera_y#, camera_z#, Rnd(0.3,3), Rnd(-3,3),Rnd(1,3),Rnd(-3,3), 255,255,255)
								Next
							Else
								PlaySound sfx_land
								For i=0 To (pl_fallspeed#)+1
									effect_puff(camera_x#+Rnd(-3,3),camera_y#,camera_z#+Rnd(-2,5),Rnd(0.2,0.6),200,150,150,Rnd(0.1,0.5))
								Next
								If pl_fallspeed# > 2.5 Then
									ct=EntityCollided(pivot, ct_slide)
									If ct Then
										If obj_typ(ct) = 9 Then damage=10
									EndIf
									If pl_fallspeed# > 4 Then damage=damage+pl_fallspeed
									If damage Then
										If pl_rubber<=0 Then
											hurt(damage)										
										EndIf
										damage = 0
									EndIf
								EndIf
							EndIf
						EndIf
						pl_jumpmode=0
						pl_fallspeed#=0				
					ElseIf EntityY(pivot)>0 Then
						pl_fallspeed#=pl_fallspeed#+0.25
						TranslateEntity pivot,0,(-0.3-pl_fallspeed#),0
					EndIf
				EndIf
							
				;Weather
				If w_rd=1 Or gm_rain=1 Then
					For i=0 To 15	
						effect_rain(camera_x#+Rnd(-30,30),camera_z#+Rnd(-30,30),Rnd(1,5),-3)
					Next
					If Not ChannelPlaying(w_chan) Then
						w_chan=PlaySound(sfx_rain)
						If Rand(3)=1 Then
							PlaySound sfx_thunder
							EntityColor lspr, 255,255,255
							EntityAlpha lspr, 1
							lspr_fade#=-0.1
							lspr_alpha#=1
						EndIf
					EndIf
				EndIf
				
				;Hi-Colors
				If pl_hi>0 Then
					pl_hi=pl_hi-2
					If pl_hi>500 Then
						HideEntity gui_kompass
						HideEntity gui_kompass_z
						If pl_hizm=0 Then
							pl_hizoom#=pl_hizoom#+0.02
							CameraZoom camera, pl_hizoom#+1
							If pl_hizoom#>=0.5 Then pl_hizm=1
						Else
							pl_hizoom#=pl_hizoom#-0.02
							CameraZoom camera, pl_hizoom#+1
							If pl_hizoom#<=0.0 Then pl_hizm=0
						EndIf 
						Select Rand(8)
							Case 1 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),80,255,80,1)
							Case 2 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,0,0,1)
							Case 3 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),0,255,0,1)
							Case 4 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),0,0,255,1)
							Case 5 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,255,0,1)
							Case 6 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,155,0,1)
							Case 7 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),255,0,255,1)
							Case 8 effect_splatter(camera_x#,camera_y#,camera_z#,Rnd(0.3,2),Rnd(-2,2),Rnd(1,3),Rnd(-2,2),0,255,255,1)
						End Select
						If Rand(15)=1 Then
							Select Rand(3)
								Case 1 EntityColor lspr, 255,0,0 : EntityAlpha lspr, 1 : lspr_alpha#=1 : lspr_fade#=-0.1
								Case 2 EntityColor lspr, 0,255,0 : EntityAlpha lspr, 1 : lspr_alpha#=1 : lspr_fade#=-0.1
								Case 3 EntityColor lspr, 0,0,255 : EntityAlpha lspr, 1 : lspr_alpha#=1 : lspr_fade#=-0.1
							End Select
						EndIf
						If Not ChannelPlaying(sfx_track) Then
							sfx_track=PlaySound(sfx_track_high)
						EndIf
					ElseIf pl_hizoom#<>0.0 Then
						pl_hizoom#=0.0
						CameraZoom camera, 1
						ShowEntity gui_kompass
						ShowEntity gui_kompass_z
					EndIf
				EndIf
				
				;Gummibeeren
				If pl_rubber>0 Then
					pl_rubber=pl_rubber-1
				EndIf
				
				;Effecte
				effects()
				
				;Items
				For item.item = Each item
					x=EntityX(item\h)
					z=EntityZ(item\h)
					If x>camera_x# Then dx=x-camera_x# Else dx=camera_x#-x
					If z>camera_z# Then dz=z-camera_z# Else dz=camera_z#-z
					If dx>opt_rangeh Then
						HideEntity item\h
					ElseIf dz>opt_rangeh Then
						HideEntity item\h
					Else
						ShowEntity item\h
						item\timer=item\timer+1
						If item\timer > 10 Then
							item\timer=Rand(-5,5)
							effect_star(EntityX(item\h)+Rnd(-1,1), EntityY(item\h), EntityZ(item\h)+Rnd(-1,1), Rnd(0.4,1), 80,255,80, Rnd(0.3,0.6), Rnd(0.035, 0.045))
						EndIf
						RotateEntity item\h,EntityPitch(item\h),EntityYaw(item\h)+0.5,EntityRoll(item\h)
					EndIf
					item\age=item\age+1
				Next
							
				;Light Sprite ausfaden
				If lspr_alpha#>0.0 Then
					lspr_alpha#=lspr_alpha#+lspr_fade#
					EntityAlpha lspr, lspr_alpha#
				EndIf
				
				;Grid repositionieren
				If grid=1 Then
					PositionEntity grid_master, 0,TerrainY(terrain, camera_x#, camera_y#, camera_z#)-25,0
				EndIf

				;Updaten
				updatetime=MilliSecs()
				UpdateWorld
				updatetime=MilliSecs()-updatetime
							
				;Camera ausrichten
				If script=0 Then
					camera_x#=EntityX(pivot)
					camera_y#=EntityY(pivot)
					camera_z#=EntityZ(pivot)
					PositionEntity camera, camera_x#, camera_y#+6, camera_z#
				EndIf
			
			EndIf	

		
		EndIf
				
				
		;Timer 2 (alle 50ms)
		If ms-timer2>=50 Then
			timer2=ms
			
			;Tool Message Update
			settool(pl_tool)
			
			;Wave
			timer_waves=timer_waves+1
			If timer_waves>10 Then
				If EntityY(pivot)<3.4 Then effect_wave(camera_x#,camera_z#,1)
				timer_waves=0
				If pl_hi>500 Then effect_puff(camera_x#+Rnd(-1,1),camera_y#+Rnd(6,8),camera_z#+Rnd(-1,1),Rnd(0.05,0.1),150,150,150,Rnd(0.7,0.9), Rnd(0.02,0.03))
			EndIf
			
			;Verstecken / Zeigen
			cull(1)
			
			;Hurt
			If gamestop=0 Then 
				If pl_tilefauna=3 Then hurt(1)
			EndIf
			
			;Environment-Sounds
			If Not ChannelPlaying(sfx_env) Then
				;Fire (Lagerfeuer/Fackel)
				If pl_tilebuild=3 Or pl_tilebuild=5 Then
					If pl_tilebuildb=0 Then
						sfx_env=PlaySound(sfx_fire)
					EndIf
				;Quelle
				ElseIf pl_tileflora=52 Then
					sfx_env=PlaySound(sfx_quelle)
				;Waves
				ElseIf TerrainY(terrain,camera_x#,0,camera_z#)<3 Then
					sfx_env=PlaySound(sfx_waves)
				EndIf
			EndIf
			
			;Sound
			If Not ChannelPlaying(sfx_chan) Then
				If gt_dn=0 Then
					sfx_chan=PlaySound (sfx_night)
				Else
					sfx_chan=PlaySound (sfx_day)
				EndIf
			EndIf
			If sfx_random>0 Then
				sfx_random=sfx_random-1
			Else
				sfx_random=100+10*(Rand(0,300))
				If TerrainY(terrain,camera_x#,0,camera_z#)<0.5 Then
				Else
					i=Rand(0,1)
					Select i
						Case 0 PlaySound sfx_bird(Rand(0,4))
						Case 1 PlaySound sfx_bee
					End Select
				EndIf
			EndIf
						
		EndIf
	
	
	;Rendern
	RenderGlow
	If ms-fpsm>1000 Then
		rendertime=MilliSecs()
		RenderWorld
		rendertime=MilliSecs()-rendertime
	Else
		RenderWorld
	EndIf

	;Pause
	If pause=1
		SetFont font_menu
		Color 255,255,255
		Text opt_sx/2,opt_sy/2-60, "Pause", 1
		If KeyHit(25) Then
			pause=0
			gamestop=0
			If gui_menu=0 Then MoveMouse(opt_sx/2,opt_sy/2) : MouseXSpeed() : MouseYSpeed()
		EndIf
	EndIf
		
	;GUI
	Include "includes/gui.bb"
		
	;Scripts
	Include "includes/scripts.bb"
	
	;Custom Mission
	If gm_custom>0 Then
		SetFont font_norm
		Color 255,255,255
		y=210
		x=0
		
		;Zeit
		If gm_time>0 Then
			If gamestop=0 Then
				If ms-gm_time_ms>1000 Then
					gm_time_ms=ms
					gm_time=gm_time-1
					If gm_time<=10 Then PlaySound sfx_pop
					If gm_time=0 Then script_run(6)
				EndIf
			EndIf
			If gm_time<=10 And gm_time Mod 2 Then Color 100,255,100
			y=y+20
			If gm_time>59 Then
				m$=Int(gm_time/60)
				s$=gm_time-(Int(m$)*60)
				If Len(m$)=1 Then m$="0"+m$
				If Len(s$)=1 Then s$="0"+s$
			Else
				m$="00"
				s$=gm_time
				If Len(s$)=1 Then s$="0"+s$
			EndIf
			Text 5,y,"Zeit: "+m$+":"+s$
		EndIf
		Color 255,255,255
		
		;Checkpoints:
		If gm_mi_checkp>0 Then
			x=x+1
			If gm_checkp<gm_mi_checkp Then
				y=y+20
				Text 5,y,"Checkpoints: "+gm_checkp+"/"+gm_mi_checkp
			EndIf
		EndIf
		;Kiwis:
		If gm_mi_kiwis>0 Then
			x=x+1
			If gm_kiwis<gm_mi_kiwis Then
				y=y+20
				Text 5,y,"Kiwis retten: "+gm_kiwis+"/"+gm_mi_kiwis
			EndIf
		EndIf
		
		;Schildkrten tten
		If gm_mi_kill(1)>0 Then
			x=x+1
			If gm_killed(1)<gm_mi_kill(1) Then
				y=y+20
				Text 5,y,"Schildkrten tten: "+gm_killed(1)+"/"+gm_mi_kill(1)
			EndIf
		EndIf
		;Krebse tten
		If gm_mi_kill(2)>0 Then
			x=x+1
			If gm_killed(2)<gm_mi_kill(2) Then
				y=y+20
				Text 5,y,"Krebse tten: "+gm_killed(2)+"/"+gm_mi_kill(2)
			EndIf
		EndIf
		;Lwen tten
		If gm_mi_kill(5)>0 Then
			x=x+1
			If gm_killed(5)<gm_mi_kill(5) Then
				y=y+20
				Text 5,y,"Lwen tten: "+gm_killed(5)+"/"+gm_mi_kill(5)
			EndIf
		EndIf
		;Kiwis tten
		If gm_mi_kill(8)>0 Then
			x=x+1
			If gm_killed(8)<gm_mi_kill(8) Then
				y=y+20
				Text 5,y,"Kiwis tten: "+gm_killed(8)+"/"+gm_mi_kill(8)
			EndIf
		EndIf
		;Opas tten
		If gm_mi_kill(6)>0 Then
			x=x+1
			If gm_killed(6)<gm_mi_kill(6) Then
				y=y+20
				Text 5,y,"Opas tten: "+gm_killed(6)+"/"+gm_mi_kill(6)
			EndIf
		EndIf
		;Raptoren tten
		If gm_mi_kill(9)>0 Then
			x=x+1
			If gm_killed(9)<gm_mi_kill(9) Then
				y=y+20
				Text 5,y,"Raptoren tten: "+gm_killed(9)+"/"+gm_mi_kill(9)
			EndIf
		EndIf
		;Soldaten tten
		If gm_mi_kill(10)>0 Then
			x=x+1
			If gm_killed(10)<gm_mi_kill(10) Then
				y=y+20
				Text 5,y,"Soldaten tten: "+gm_killed(10)+"/"+gm_mi_kill(10)
			EndIf
		EndIf
		;Eingeborene tten
		If gm_mi_kill(11)>0 Then
			x=x+1
			If gm_killed(11)<gm_mi_kill(11) Then
				y=y+20
				Text 5,y,"Eingeborene tten: "+gm_killed(11)+"/"+gm_mi_kill(11)
			EndIf
		EndIf
		
		;Ziel erreichen:
		If gm_mi_finish>0 Then
			x=x+1
			If pl_tilebuild<>11 Then
				y=y+20
				Text 5,y,"Ziel erreichen"
			EndIf
		EndIf
		
		;Sieg testen
		If gm_time>0 Then y=y-20
		If x>0 Then
			If y=210 Then
				If script<>5 Then
					script_run(5)
				EndIf
			EndIf
		EndIf
		
		;Track
		If sfx_gmtrack<>0 Then
			If Not ChannelPlaying(sfx_track) Then
				sfx_track=PlaySound(sfx_gmtrack)
			EndIf
		EndIf
		
	EndIf
	
	;Mauszeiger
	If gui_on=1 Or gui_offset<148 Then
		DrawImage gfx_gui_pointer, mx,my
	ElseIf gui_messageon=1 Then
		DrawImage gfx_gui_pointer, mx,my
	EndIf
	
	;looptime
	looptime=MilliSecs()-looptime
	
	;Debug
	If opt_debug=1 Then
		Color 255,255,255
		SetFont font_tiny
		If ms-fpsm>1000 Then
			fps=fpst
			fpst=0
			fpsm=ms
		EndIf
		fpst=fpst+1
		Text 75,0,"FPS: "+fps+"  Triangles: "+TrisRendered()+"  Render: "+rendertime+" ms Update"+updatetime+" ms Loop "+looptime+" ms"
		Text 75,15,"Mouse x|y: "+MouseX()+"|"+MouseY()
		Text 75,30,"Pos x|y|z: "+camera_x#+"|"+camera_y#+"|"+camera_z#
		Text 75,45,"Dir pitch|yaw|roll: "+EntityPitch(camera)+"|"+EntityYaw(camera)+"|"+EntityRoll(camera)
		Text 75,60,"Free Memory (MB): "+(AvailVidMem ()/1024/1024)+"/"+(TotalVidMem()/1024/1024)+"  Used: "+((TotalVidMem()/1024/1024)-(AvailVidMem()/1024/1024))
		Text 450,0, "Tile Pos x|y: "+Int(camera_x#/15)+"|"+Int(camera_z#/15)
		Text 450,15, "Tile Build: "+pl_tilebuild
		Text 450,30, "Tile Flora: "+pl_tileflora
		Text 450,45, "Tile Fauna: "+pl_tilefauna
		Text 800,0, "Light: "+(150-gt_light)
		Text 800,15, "High: "+pl_hi
		If EntityCollided(pivot,ct_slide) Then Text 800,30, "pivot collides with a slide"
		If EntityCollided(pivot,ct_fauna) Then Text 800,30, "pivot collides with a fauna"
		If EntityCollided(cpivot,ct_slide) Then Text 800,45, "climb pivot collides with a slide"
	EndIf
			
	;Flippen
	Flip opt_vsync
	
Forever
FlushKeys()
StopChannel sfx_track
StopChannel sfx_env
StopChannel w_chan
clear()
menu_set(0)
Goto menu


;-----------------------------------------------Editor Schleife
.editor
updatelight(150)
FlushMouse()
game_editor()
Repeat 
	leave=editor()
	If leave=1 Then Exit
Forever
FlushKeys()
StopChannel sfx_track
StopChannel sfx_env
StopChannel w_chan
clear()
menu_set(0)
Goto menu





;Zustzliche Functions
Include "includes/functions.bb"

Function cull(actions=1, ki=1)
			
	;Verstecken/Zeigen - Flora
	For e_flora.flora = Each flora
		ob_h=e_flora\h
		ob_x=EntityX(ob_h)
		ob_z=EntityZ(ob_h)
		If ob_x>camera_x# Then ob_dx=ob_x-camera_x# Else ob_dx=camera_x#-ob_x
		If ob_z>camera_z# Then ob_dz=ob_z-camera_z# Else ob_dz=camera_z#-ob_z
		If ob_dx>opt_rangeh Then
			If e_flora\visible=1 Then
				HideEntity ob_h
				e_flora\visible=0
			EndIf
		ElseIf ob_dz>opt_rangeh Then
			If e_flora\visible=1 Then
				HideEntity ob_h
				e_flora\visible=0
			EndIf
		ElseIf EntityInView(ob_h, camera)
			If e_flora\visible=0 Then
				ShowEntity ob_h
				e_flora\visible=1
			EndIf
		ElseIf ob_dx>20 And ob_dz>20
			If e_flora\visible=1 Then
				HideEntity ob_h
				e_flora\visible=0
			EndIf	
		Else
			If e_flora\visible=0 Then
				ShowEntity ob_h
				e_flora\visible=1
			EndIf					
		EndIf
		If actions=1 Then
			If gamestop=0 Then flora()
		EndIf
	Next
			
	;Verstecken/Zeigen - Fauna
	pl_trade=0
	pl_train=0
	For e_fauna.fauna = Each fauna
		ob_h=e_fauna\h
		ob_x=EntityX(ob_h)
		ob_z=EntityZ(ob_h)		
		If ob_x>camera_x# Then ob_dx=ob_x-camera_x# Else ob_dx=camera_x#-ob_x
		If ob_z>camera_z# Then ob_dz=ob_z-camera_z# Else ob_dz=camera_z#-ob_z
		If ob_dx>opt_rangeh Then
			If e_fauna\visible=1 Then
				HideEntity ob_h
				e_fauna\visible=0
			EndIf
		ElseIf ob_dz>opt_rangeh Then
			If e_fauna\visible=1 Then
				HideEntity ob_h
				e_fauna\visible=0
			EndIf
		Else
			If e_fauna\visible=0 Then
				ShowEntity ob_h
				e_fauna\visible=1
			EndIf
		EndIf
		If actions=1 Then
			If ki=1 Then
				If gamestop=0 Then ki()
			EndIf
		EndIf
	Next
			
	;Verstecken/Zeigen - Statics
	For e_static.static = Each static
		ob_h=e_static\h
		ob_x=EntityX(ob_h)
		ob_z=EntityZ(ob_h)		
		If ob_x>camera_x# Then ob_dx=ob_x-camera_x# Else ob_dx=camera_x#-ob_x
		If ob_z>camera_z# Then ob_dz=ob_z-camera_z# Else ob_dz=camera_z#-ob_z
		If ob_dx>opt_rangeh Then
			If e_static\visible=1 Then
				HideEntity ob_h
				e_static\visible=0
			EndIf
		ElseIf ob_dz>opt_rangeh Then
			If e_static\visible=1 Then
				HideEntity ob_h
				e_static\visible=0
			EndIf
		ElseIf EntityInView(ob_h, camera)
			If e_static\visible=0 Then
				ShowEntity ob_h
				e_static\visible=1
			EndIf
		Else
			If e_static\visible=1 Then
				HideEntity ob_h
				e_static\visible=0
			EndIf
		EndIf					
	Next
			
	;Verstecken/Zeigen - Buildings
	For building.building = Each building
		ob_h=building\h1
		ob_x=EntityX(ob_h)
		ob_z=EntityZ(ob_h)		
		If ob_x>camera_x# Then ob_dx=ob_x-camera_x# Else ob_dx=camera_x#-ob_x
		If ob_z>camera_z# Then ob_dz=ob_z-camera_z# Else ob_dz=camera_z#-ob_z
		If ob_dx>opt_rangeh Then
			If building\visible=1 Then
				HideEntity ob_h
				HideEntity building\h2
				HideEntity building\h3
				building\visible=0
			EndIf
		ElseIf ob_dz>opt_rangeh Then
			If building\visible=1 Then
				HideEntity ob_h
				HideEntity building\h2
				HideEntity building\h3
				building\visible=0
			EndIf
		ElseIf EntityInView(ob_h, camera)
			If building\visible=0 Then
				ShowEntity ob_h
				ShowEntity building\h2
				ShowEntity building\h3
				building\visible=1
			EndIf
		ElseIf ob_dx>50 And ob_dz>50 Then
			If building\visible=1
				HideEntity ob_h
				HideEntity building\h2
				HideEntity building\h3
				building\visible=0
			EndIf
		Else
			If building\visible=0 Then
				ShowEntity ob_h
				ShowEntity building\h2
				ShowEntity building\h3
				building\visible=1
			EndIf		
		EndIf
		If actions=1 Then
			If gamestop=0 And building\visible=1 Then
				;Baustelle
				If building\req_total>0 Then
					building\timer=building\timer+1
					If building\timer > 10 Then
						building\timer=Rand(-5,5)
						effect_star(EntityX(building\h1)+Rnd(-7,7), EntityY(building\h1), EntityZ(building\h1)+Rnd(-7,7), Rnd(0.4,1), 80,255,80, Rnd(0.3,0.6), Rnd(0.035, 0.045))
					EndIf
				;Feuer
				ElseIf building\typ=3 Then
					If Rand(10)=1 Then effect_puff(EntityX(building\h1)+Rnd(-1,1),EntityY(building\h1)+Rnd(5,9),EntityZ(building\h1)+Rnd(-1,1),Rnd(0.1,0.2),150,150,150,Rnd(0.3,0.7), Rnd(0.03,0.06)) 
					If Rand(10)=1 Then effect_splatter(EntityX(building\h1)+Rnd(-1,1), EntityY(building\h1)+Rnd(1,2), EntityZ(building\h1)+Rnd(-1,1), Rnd(0.3,2), Rnd(-3,3),Rnd(1,3),Rnd(-3,3), 255,0,0)
					If Rand(10)=1 Then effect_splatter(EntityX(building\h1)+Rnd(-1,1), EntityY(building\h1)+Rnd(1,2), EntityZ(building\h1)+Rnd(-1,1), Rnd(0.3,2), Rnd(-3,3),Rnd(1,3),Rnd(-3,3), 255,255,0)
					building\mode=building\mode+1
					x=building\mode
					If x<=10 Then
						ScaleSprite building\h2, 3.0+(Float(x)/15.0),8.0+(Float(x)/10.0)
					Else
						If x=20 Then building\mode=0
						x=x-10
						ScaleSprite building\h2, 3.7-(Float(x)/15.0),9.0-(Float(x)/10.0)
					EndIf
					LightColor building\h3, 255,Rand(80,200),0
					LightRange building\h3, Rnd(15,18)
				;Boot
				ElseIf building\typ=4 Then
					If building\h1<>pl_driveh Then
						If building\mode=0 Then
							RotateEntity building\h1, EntityPitch(building\h1),EntityYaw(building\h1),EntityRoll(building\h1)+0.2
							If EntityRoll(building\h1)>=3 Then building\mode=1
						Else
							RotateEntity building\h1, EntityPitch(building\h1),EntityYaw(building\h1),EntityRoll(building\h1)-0.2
							If EntityRoll(building\h1)<=-3 Then building\mode=0
						EndIf
					Else
						RotateEntity building\h1, EntityPitch(building\h1),EntityYaw(building\h1),0
					EndIf
				;Fackel
				ElseIf building\typ=5 Then
					If Rand(20)=1 Then effect_puff(EntityX(building\h1)+Rnd(-1,1),EntityY(building\h1)+Rnd(12,16),EntityZ(building\h1)+Rnd(-1,1),Rnd(0.1,0.2),150,150,150,Rnd(0.2,0.6), Rnd(0.03,0.06)) 
					building\mode=building\mode+1
					x=building\mode
					If x<=10 Then
						ScaleSprite building\h2, 1.5+(Float(x)/15.0),5.0+(Float(x)/10.0)
					Else
						If x=20 Then building\mode=0
						x=x-10
						ScaleSprite building\h2, 2.2-(Float(x)/15.0),6.0-(Float(x)/10.0)
					EndIf
					LightColor building\h3, 255,Rand(80,200),0
					LightRange building\h3, Rnd(15,18)
				;Reuse
				ElseIf building\typ=7 Then
					If timer_waves=0 Then
						If building\mode>0 Then
							effect_wave(EntityX(building\h1),EntityZ(building\h1),2)
						EndIf
					EndIf
				;Checkpoint
				ElseIf building\typ=10 Then
					If building\mode=10 Then
						effect_star(EntityX(building\h1)+Rnd(-1,1), EntityY(building\h1)+12, EntityZ(building\h1)+Rnd(-1,1), Rnd(0.4,1), 255,255,0, Rnd(0.3,0.6), Rnd(0.035, 0.045))	
					EndIf
				EndIf
			EndIf
		EndIf
	Next
			
End Function


;Gametime
Function gametime()
	If ms-gt>gamespeed Then
		gt=ms
		If gm_frozentime=0 Then gt_min=gt_min+1
		If gt_hour>=6 Then
			gt_light=150-((gt_hour-6)*60+gt_min)
			If gt_hour>=19 Then
				gt_light=(gt_hour-20)*60+gt_min
			EndIf
		EndIf
		If gt_light<0 Then gt_light=0
		If gt_light>120 Then gt_light=120
		updatelight(150-gt_light)
		If gt_min>=60 Then
			gt_min=0
			gt_hour=gt_hour+1
			If gt_hour=7 Then
				w_rd=0
				If Rand(0,9)=1 Then w_rd=1
			EndIf
			message_time()
			If gt_hour>=20 Or gt_hour<6 Then
				gt_dn=0
			Else
				gt_dn=1
			EndIf
			If gt_hour>=24 Then
				gt_hour=0
				gt_day=gt_day+1
			EndIf
		EndIf
	EndIf
End Function